<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productInformations StructType
 * @subpackage Structs
 */
class ProductInformations extends AbstractStructBase
{
    /**
     * The productId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $productId;
    /**
     * The productCategoryId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $productCategoryId;
    /**
     * The productStartDayPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $productStartDayPeriod;
    /**
     * The availabilityState
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $availabilityState;
    /**
     * The productInventory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $productInventory;
    /**
     * The productAvailabilityDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\ProductAvailabilityDate
     */
    public $productAvailabilityDate;
    /**
     * The productSpecialOffer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var \StructType\ProductSpecialOffer
     */
    public $productSpecialOffer;
    /**
     * The onlyOnLine
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $onlyOnLine;
    /**
     * The productBaseOrder
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $productBaseOrder;
    /**
     * The hasDiscountCodeOffer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $hasDiscountCodeOffer;
    /**
     * The productName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productName;
    /**
     * The productCategoryName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productCategoryName;
    /**
     * The productText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productText;
    /**
     * The productType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productType;
    /**
     * The productNbPers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productNbPers;
    /**
     * The productNbPersMin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productNbPersMin;
    /**
     * The productNbPersMax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productNbPersMax;
    /**
     * The productNbPersIncluded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productNbPersIncluded;
    /**
     * The productUrl360
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productUrl360;
    /**
     * The periods
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductPeriod
     */
    public $periods;
    /**
     * The productPictures
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPicture
     */
    public $productPictures;
    /**
     * The lastUpdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LastUpdate
     */
    public $lastUpdate;
    /**
     * The productPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProductPrice
     */
    public $productPrice;
    /**
     * The engineSpecialOffer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EngineSpecialOffer
     */
    public $engineSpecialOffer;
    /**
     * The urlBooking
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlBooking;
    /**
     * The urlProduct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlProduct;
    /**
     * The secureHolidayProductAvailabilitySpecifications
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SecureHolidayProductAvailabilitySpecifications
     */
    public $secureHolidayProductAvailabilitySpecifications;
    /**
     * The detailsPricing
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductPricing
     */
    public $detailsPricing;
    /**
     * The marketingTags
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt_1
     */
    public $marketingTags;
    /**
     * The minimalOptionsString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $minimalOptionsString;
    /**
     * The includedOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOption
     */
    public $includedOptions;
    /**
     * The extraOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOption
     */
    public $extraOptions;
    /**
     * The minimalOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOptionSelected
     */
    public $minimalOptions;
    /**
     * The specificCustomerOptionList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfSpecificCustomerOption
     */
    public $specificCustomerOptionList;
    /**
     * Constructor method for productInformations
     * @uses ProductInformations::setProductId()
     * @uses ProductInformations::setProductCategoryId()
     * @uses ProductInformations::setProductStartDayPeriod()
     * @uses ProductInformations::setAvailabilityState()
     * @uses ProductInformations::setProductInventory()
     * @uses ProductInformations::setProductAvailabilityDate()
     * @uses ProductInformations::setProductSpecialOffer()
     * @uses ProductInformations::setOnlyOnLine()
     * @uses ProductInformations::setProductBaseOrder()
     * @uses ProductInformations::setHasDiscountCodeOffer()
     * @uses ProductInformations::setProductName()
     * @uses ProductInformations::setProductCategoryName()
     * @uses ProductInformations::setProductText()
     * @uses ProductInformations::setProductType()
     * @uses ProductInformations::setProductNbPers()
     * @uses ProductInformations::setProductNbPersMin()
     * @uses ProductInformations::setProductNbPersMax()
     * @uses ProductInformations::setProductNbPersIncluded()
     * @uses ProductInformations::setProductUrl360()
     * @uses ProductInformations::setPeriods()
     * @uses ProductInformations::setProductPictures()
     * @uses ProductInformations::setLastUpdate()
     * @uses ProductInformations::setProductPrice()
     * @uses ProductInformations::setEngineSpecialOffer()
     * @uses ProductInformations::setUrlBooking()
     * @uses ProductInformations::setUrlProduct()
     * @uses ProductInformations::setSecureHolidayProductAvailabilitySpecifications()
     * @uses ProductInformations::setDetailsPricing()
     * @uses ProductInformations::setMarketingTags()
     * @uses ProductInformations::setMinimalOptionsString()
     * @uses ProductInformations::setIncludedOptions()
     * @uses ProductInformations::setExtraOptions()
     * @uses ProductInformations::setMinimalOptions()
     * @uses ProductInformations::setSpecificCustomerOptionList()
     * @param int $productId
     * @param int $productCategoryId
     * @param string $productStartDayPeriod
     * @param string $availabilityState
     * @param string $productInventory
     * @param \StructType\ProductAvailabilityDate $productAvailabilityDate
     * @param \StructType\ProductSpecialOffer $productSpecialOffer
     * @param int $onlyOnLine
     * @param int $productBaseOrder
     * @param bool $hasDiscountCodeOffer
     * @param string $productName
     * @param string $productCategoryName
     * @param string $productText
     * @param string $productType
     * @param string $productNbPers
     * @param string $productNbPersMin
     * @param string $productNbPersMax
     * @param string $productNbPersIncluded
     * @param string $productUrl360
     * @param \ArrayType\ArrayOfProductPeriod $periods
     * @param \ArrayType\ArrayOfPicture $productPictures
     * @param \StructType\LastUpdate $lastUpdate
     * @param \StructType\ProductPrice $productPrice
     * @param \StructType\EngineSpecialOffer $engineSpecialOffer
     * @param string $urlBooking
     * @param string $urlProduct
     * @param \StructType\SecureHolidayProductAvailabilitySpecifications $secureHolidayProductAvailabilitySpecifications
     * @param \ArrayType\ArrayOfProductPricing $detailsPricing
     * @param \ArrayType\ArrayOfInt_1 $marketingTags
     * @param string $minimalOptionsString
     * @param \ArrayType\ArrayOfOption $includedOptions
     * @param \ArrayType\ArrayOfOption $extraOptions
     * @param \ArrayType\ArrayOfOptionSelected $minimalOptions
     * @param \ArrayType\ArrayOfSpecificCustomerOption $specificCustomerOptionList
     */
    public function __construct($productId = null, $productCategoryId = null, $productStartDayPeriod = null, $availabilityState = null, $productInventory = null, \StructType\ProductAvailabilityDate $productAvailabilityDate = null, \StructType\ProductSpecialOffer $productSpecialOffer = null, $onlyOnLine = null, $productBaseOrder = null, $hasDiscountCodeOffer = null, $productName = null, $productCategoryName = null, $productText = null, $productType = null, $productNbPers = null, $productNbPersMin = null, $productNbPersMax = null, $productNbPersIncluded = null, $productUrl360 = null, \ArrayType\ArrayOfProductPeriod $periods = null, \ArrayType\ArrayOfPicture $productPictures = null, \StructType\LastUpdate $lastUpdate = null, \StructType\ProductPrice $productPrice = null, \StructType\EngineSpecialOffer $engineSpecialOffer = null, $urlBooking = null, $urlProduct = null, \StructType\SecureHolidayProductAvailabilitySpecifications $secureHolidayProductAvailabilitySpecifications = null, \ArrayType\ArrayOfProductPricing $detailsPricing = null, \ArrayType\ArrayOfInt_1 $marketingTags = null, $minimalOptionsString = null, \ArrayType\ArrayOfOption $includedOptions = null, \ArrayType\ArrayOfOption $extraOptions = null, \ArrayType\ArrayOfOptionSelected $minimalOptions = null, \ArrayType\ArrayOfSpecificCustomerOption $specificCustomerOptionList = null)
    {
        $this
            ->setProductId($productId)
            ->setProductCategoryId($productCategoryId)
            ->setProductStartDayPeriod($productStartDayPeriod)
            ->setAvailabilityState($availabilityState)
            ->setProductInventory($productInventory)
            ->setProductAvailabilityDate($productAvailabilityDate)
            ->setProductSpecialOffer($productSpecialOffer)
            ->setOnlyOnLine($onlyOnLine)
            ->setProductBaseOrder($productBaseOrder)
            ->setHasDiscountCodeOffer($hasDiscountCodeOffer)
            ->setProductName($productName)
            ->setProductCategoryName($productCategoryName)
            ->setProductText($productText)
            ->setProductType($productType)
            ->setProductNbPers($productNbPers)
            ->setProductNbPersMin($productNbPersMin)
            ->setProductNbPersMax($productNbPersMax)
            ->setProductNbPersIncluded($productNbPersIncluded)
            ->setProductUrl360($productUrl360)
            ->setPeriods($periods)
            ->setProductPictures($productPictures)
            ->setLastUpdate($lastUpdate)
            ->setProductPrice($productPrice)
            ->setEngineSpecialOffer($engineSpecialOffer)
            ->setUrlBooking($urlBooking)
            ->setUrlProduct($urlProduct)
            ->setSecureHolidayProductAvailabilitySpecifications($secureHolidayProductAvailabilitySpecifications)
            ->setDetailsPricing($detailsPricing)
            ->setMarketingTags($marketingTags)
            ->setMinimalOptionsString($minimalOptionsString)
            ->setIncludedOptions($includedOptions)
            ->setExtraOptions($extraOptions)
            ->setMinimalOptions($minimalOptions)
            ->setSpecificCustomerOptionList($specificCustomerOptionList);
    }
    /**
     * Get productId value
     * @return int
     */
    public function getProductId()
    {
        return $this->productId;
    }
    /**
     * Set productId value
     * @param int $productId
     * @return \StructType\ProductInformations
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: int
        if (!is_null($productId) && !(is_int($productId) || ctype_digit($productId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        $this->productId = $productId;
        return $this;
    }
    /**
     * Get productCategoryId value
     * @return int
     */
    public function getProductCategoryId()
    {
        return $this->productCategoryId;
    }
    /**
     * Set productCategoryId value
     * @param int $productCategoryId
     * @return \StructType\ProductInformations
     */
    public function setProductCategoryId($productCategoryId = null)
    {
        // validation for constraint: int
        if (!is_null($productCategoryId) && !(is_int($productCategoryId) || ctype_digit($productCategoryId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productCategoryId, true), gettype($productCategoryId)), __LINE__);
        }
        $this->productCategoryId = $productCategoryId;
        return $this;
    }
    /**
     * Get productStartDayPeriod value
     * @return string
     */
    public function getProductStartDayPeriod()
    {
        return $this->productStartDayPeriod;
    }
    /**
     * Set productStartDayPeriod value
     * @uses \EnumType\ProductStartDayPeriod::valueIsValid()
     * @uses \EnumType\ProductStartDayPeriod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productStartDayPeriod
     * @return \StructType\ProductInformations
     */
    public function setProductStartDayPeriod($productStartDayPeriod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductStartDayPeriod::valueIsValid($productStartDayPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductStartDayPeriod', is_array($productStartDayPeriod) ? implode(', ', $productStartDayPeriod) : var_export($productStartDayPeriod, true), implode(', ', \EnumType\ProductStartDayPeriod::getValidValues())), __LINE__);
        }
        $this->productStartDayPeriod = $productStartDayPeriod;
        return $this;
    }
    /**
     * Get availabilityState value
     * @return string
     */
    public function getAvailabilityState()
    {
        return $this->availabilityState;
    }
    /**
     * Set availabilityState value
     * @uses \EnumType\AvailabilityState::valueIsValid()
     * @uses \EnumType\AvailabilityState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityState
     * @return \StructType\ProductInformations
     */
    public function setAvailabilityState($availabilityState = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AvailabilityState::valueIsValid($availabilityState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AvailabilityState', is_array($availabilityState) ? implode(', ', $availabilityState) : var_export($availabilityState, true), implode(', ', \EnumType\AvailabilityState::getValidValues())), __LINE__);
        }
        $this->availabilityState = $availabilityState;
        return $this;
    }
    /**
     * Get productInventory value
     * @return string
     */
    public function getProductInventory()
    {
        return $this->productInventory;
    }
    /**
     * Set productInventory value
     * @uses \EnumType\ProductInventory::valueIsValid()
     * @uses \EnumType\ProductInventory::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productInventory
     * @return \StructType\ProductInformations
     */
    public function setProductInventory($productInventory = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductInventory::valueIsValid($productInventory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductInventory', is_array($productInventory) ? implode(', ', $productInventory) : var_export($productInventory, true), implode(', ', \EnumType\ProductInventory::getValidValues())), __LINE__);
        }
        $this->productInventory = $productInventory;
        return $this;
    }
    /**
     * Get productAvailabilityDate value
     * @return \StructType\ProductAvailabilityDate
     */
    public function getProductAvailabilityDate()
    {
        return $this->productAvailabilityDate;
    }
    /**
     * Set productAvailabilityDate value
     * @param \StructType\ProductAvailabilityDate $productAvailabilityDate
     * @return \StructType\ProductInformations
     */
    public function setProductAvailabilityDate(\StructType\ProductAvailabilityDate $productAvailabilityDate = null)
    {
        $this->productAvailabilityDate = $productAvailabilityDate;
        return $this;
    }
    /**
     * Get productSpecialOffer value
     * @return \StructType\ProductSpecialOffer
     */
    public function getProductSpecialOffer()
    {
        return $this->productSpecialOffer;
    }
    /**
     * Set productSpecialOffer value
     * @param \StructType\ProductSpecialOffer $productSpecialOffer
     * @return \StructType\ProductInformations
     */
    public function setProductSpecialOffer(\StructType\ProductSpecialOffer $productSpecialOffer = null)
    {
        $this->productSpecialOffer = $productSpecialOffer;
        return $this;
    }
    /**
     * Get onlyOnLine value
     * @return int
     */
    public function getOnlyOnLine()
    {
        return $this->onlyOnLine;
    }
    /**
     * Set onlyOnLine value
     * @param int $onlyOnLine
     * @return \StructType\ProductInformations
     */
    public function setOnlyOnLine($onlyOnLine = null)
    {
        // validation for constraint: int
        if (!is_null($onlyOnLine) && !(is_int($onlyOnLine) || ctype_digit($onlyOnLine))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($onlyOnLine, true), gettype($onlyOnLine)), __LINE__);
        }
        $this->onlyOnLine = $onlyOnLine;
        return $this;
    }
    /**
     * Get productBaseOrder value
     * @return int
     */
    public function getProductBaseOrder()
    {
        return $this->productBaseOrder;
    }
    /**
     * Set productBaseOrder value
     * @param int $productBaseOrder
     * @return \StructType\ProductInformations
     */
    public function setProductBaseOrder($productBaseOrder = null)
    {
        // validation for constraint: int
        if (!is_null($productBaseOrder) && !(is_int($productBaseOrder) || ctype_digit($productBaseOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($productBaseOrder, true), gettype($productBaseOrder)), __LINE__);
        }
        $this->productBaseOrder = $productBaseOrder;
        return $this;
    }
    /**
     * Get hasDiscountCodeOffer value
     * @return bool
     */
    public function getHasDiscountCodeOffer()
    {
        return $this->hasDiscountCodeOffer;
    }
    /**
     * Set hasDiscountCodeOffer value
     * @param bool $hasDiscountCodeOffer
     * @return \StructType\ProductInformations
     */
    public function setHasDiscountCodeOffer($hasDiscountCodeOffer = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasDiscountCodeOffer) && !is_bool($hasDiscountCodeOffer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasDiscountCodeOffer, true), gettype($hasDiscountCodeOffer)), __LINE__);
        }
        $this->hasDiscountCodeOffer = $hasDiscountCodeOffer;
        return $this;
    }
    /**
     * Get productName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return \StructType\ProductInformations
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get productCategoryName value
     * @return string|null
     */
    public function getProductCategoryName()
    {
        return $this->productCategoryName;
    }
    /**
     * Set productCategoryName value
     * @param string $productCategoryName
     * @return \StructType\ProductInformations
     */
    public function setProductCategoryName($productCategoryName = null)
    {
        // validation for constraint: string
        if (!is_null($productCategoryName) && !is_string($productCategoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productCategoryName, true), gettype($productCategoryName)), __LINE__);
        }
        $this->productCategoryName = $productCategoryName;
        return $this;
    }
    /**
     * Get productText value
     * @return string|null
     */
    public function getProductText()
    {
        return $this->productText;
    }
    /**
     * Set productText value
     * @param string $productText
     * @return \StructType\ProductInformations
     */
    public function setProductText($productText = null)
    {
        // validation for constraint: string
        if (!is_null($productText) && !is_string($productText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productText, true), gettype($productText)), __LINE__);
        }
        $this->productText = $productText;
        return $this;
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @param string $productType
     * @return \StructType\ProductInformations
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: string
        if (!is_null($productType) && !is_string($productType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productType, true), gettype($productType)), __LINE__);
        }
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get productNbPers value
     * @return string|null
     */
    public function getProductNbPers()
    {
        return $this->productNbPers;
    }
    /**
     * Set productNbPers value
     * @param string $productNbPers
     * @return \StructType\ProductInformations
     */
    public function setProductNbPers($productNbPers = null)
    {
        // validation for constraint: string
        if (!is_null($productNbPers) && !is_string($productNbPers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productNbPers, true), gettype($productNbPers)), __LINE__);
        }
        $this->productNbPers = $productNbPers;
        return $this;
    }
    /**
     * Get productNbPersMin value
     * @return string|null
     */
    public function getProductNbPersMin()
    {
        return $this->productNbPersMin;
    }
    /**
     * Set productNbPersMin value
     * @param string $productNbPersMin
     * @return \StructType\ProductInformations
     */
    public function setProductNbPersMin($productNbPersMin = null)
    {
        // validation for constraint: string
        if (!is_null($productNbPersMin) && !is_string($productNbPersMin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productNbPersMin, true), gettype($productNbPersMin)), __LINE__);
        }
        $this->productNbPersMin = $productNbPersMin;
        return $this;
    }
    /**
     * Get productNbPersMax value
     * @return string|null
     */
    public function getProductNbPersMax()
    {
        return $this->productNbPersMax;
    }
    /**
     * Set productNbPersMax value
     * @param string $productNbPersMax
     * @return \StructType\ProductInformations
     */
    public function setProductNbPersMax($productNbPersMax = null)
    {
        // validation for constraint: string
        if (!is_null($productNbPersMax) && !is_string($productNbPersMax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productNbPersMax, true), gettype($productNbPersMax)), __LINE__);
        }
        $this->productNbPersMax = $productNbPersMax;
        return $this;
    }
    /**
     * Get productNbPersIncluded value
     * @return string|null
     */
    public function getProductNbPersIncluded()
    {
        return $this->productNbPersIncluded;
    }
    /**
     * Set productNbPersIncluded value
     * @param string $productNbPersIncluded
     * @return \StructType\ProductInformations
     */
    public function setProductNbPersIncluded($productNbPersIncluded = null)
    {
        // validation for constraint: string
        if (!is_null($productNbPersIncluded) && !is_string($productNbPersIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productNbPersIncluded, true), gettype($productNbPersIncluded)), __LINE__);
        }
        $this->productNbPersIncluded = $productNbPersIncluded;
        return $this;
    }
    /**
     * Get productUrl360 value
     * @return string|null
     */
    public function getProductUrl360()
    {
        return $this->productUrl360;
    }
    /**
     * Set productUrl360 value
     * @param string $productUrl360
     * @return \StructType\ProductInformations
     */
    public function setProductUrl360($productUrl360 = null)
    {
        // validation for constraint: string
        if (!is_null($productUrl360) && !is_string($productUrl360)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productUrl360, true), gettype($productUrl360)), __LINE__);
        }
        $this->productUrl360 = $productUrl360;
        return $this;
    }
    /**
     * Get periods value
     * @return \ArrayType\ArrayOfProductPeriod|null
     */
    public function getPeriods()
    {
        return $this->periods;
    }
    /**
     * Set periods value
     * @param \ArrayType\ArrayOfProductPeriod $periods
     * @return \StructType\ProductInformations
     */
    public function setPeriods(\ArrayType\ArrayOfProductPeriod $periods = null)
    {
        $this->periods = $periods;
        return $this;
    }
    /**
     * Get productPictures value
     * @return \ArrayType\ArrayOfPicture|null
     */
    public function getProductPictures()
    {
        return $this->productPictures;
    }
    /**
     * Set productPictures value
     * @param \ArrayType\ArrayOfPicture $productPictures
     * @return \StructType\ProductInformations
     */
    public function setProductPictures(\ArrayType\ArrayOfPicture $productPictures = null)
    {
        $this->productPictures = $productPictures;
        return $this;
    }
    /**
     * Get lastUpdate value
     * @return \StructType\LastUpdate|null
     */
    public function getLastUpdate()
    {
        return $this->lastUpdate;
    }
    /**
     * Set lastUpdate value
     * @param \StructType\LastUpdate $lastUpdate
     * @return \StructType\ProductInformations
     */
    public function setLastUpdate(\StructType\LastUpdate $lastUpdate = null)
    {
        $this->lastUpdate = $lastUpdate;
        return $this;
    }
    /**
     * Get productPrice value
     * @return \StructType\ProductPrice|null
     */
    public function getProductPrice()
    {
        return $this->productPrice;
    }
    /**
     * Set productPrice value
     * @param \StructType\ProductPrice $productPrice
     * @return \StructType\ProductInformations
     */
    public function setProductPrice(\StructType\ProductPrice $productPrice = null)
    {
        $this->productPrice = $productPrice;
        return $this;
    }
    /**
     * Get engineSpecialOffer value
     * @return \StructType\EngineSpecialOffer|null
     */
    public function getEngineSpecialOffer()
    {
        return $this->engineSpecialOffer;
    }
    /**
     * Set engineSpecialOffer value
     * @param \StructType\EngineSpecialOffer $engineSpecialOffer
     * @return \StructType\ProductInformations
     */
    public function setEngineSpecialOffer(\StructType\EngineSpecialOffer $engineSpecialOffer = null)
    {
        $this->engineSpecialOffer = $engineSpecialOffer;
        return $this;
    }
    /**
     * Get urlBooking value
     * @return string|null
     */
    public function getUrlBooking()
    {
        return $this->urlBooking;
    }
    /**
     * Set urlBooking value
     * @param string $urlBooking
     * @return \StructType\ProductInformations
     */
    public function setUrlBooking($urlBooking = null)
    {
        // validation for constraint: string
        if (!is_null($urlBooking) && !is_string($urlBooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlBooking, true), gettype($urlBooking)), __LINE__);
        }
        $this->urlBooking = $urlBooking;
        return $this;
    }
    /**
     * Get urlProduct value
     * @return string|null
     */
    public function getUrlProduct()
    {
        return $this->urlProduct;
    }
    /**
     * Set urlProduct value
     * @param string $urlProduct
     * @return \StructType\ProductInformations
     */
    public function setUrlProduct($urlProduct = null)
    {
        // validation for constraint: string
        if (!is_null($urlProduct) && !is_string($urlProduct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlProduct, true), gettype($urlProduct)), __LINE__);
        }
        $this->urlProduct = $urlProduct;
        return $this;
    }
    /**
     * Get secureHolidayProductAvailabilitySpecifications value
     * @return \StructType\SecureHolidayProductAvailabilitySpecifications|null
     */
    public function getSecureHolidayProductAvailabilitySpecifications()
    {
        return $this->secureHolidayProductAvailabilitySpecifications;
    }
    /**
     * Set secureHolidayProductAvailabilitySpecifications value
     * @param \StructType\SecureHolidayProductAvailabilitySpecifications $secureHolidayProductAvailabilitySpecifications
     * @return \StructType\ProductInformations
     */
    public function setSecureHolidayProductAvailabilitySpecifications(\StructType\SecureHolidayProductAvailabilitySpecifications $secureHolidayProductAvailabilitySpecifications = null)
    {
        $this->secureHolidayProductAvailabilitySpecifications = $secureHolidayProductAvailabilitySpecifications;
        return $this;
    }
    /**
     * Get detailsPricing value
     * @return \ArrayType\ArrayOfProductPricing|null
     */
    public function getDetailsPricing()
    {
        return $this->detailsPricing;
    }
    /**
     * Set detailsPricing value
     * @param \ArrayType\ArrayOfProductPricing $detailsPricing
     * @return \StructType\ProductInformations
     */
    public function setDetailsPricing(\ArrayType\ArrayOfProductPricing $detailsPricing = null)
    {
        $this->detailsPricing = $detailsPricing;
        return $this;
    }
    /**
     * Get marketingTags value
     * @return \ArrayType\ArrayOfInt_1|null
     */
    public function getMarketingTags()
    {
        return $this->marketingTags;
    }
    /**
     * Set marketingTags value
     * @param \ArrayType\ArrayOfInt_1 $marketingTags
     * @return \StructType\ProductInformations
     */
    public function setMarketingTags(\ArrayType\ArrayOfInt_1 $marketingTags = null)
    {
        $this->marketingTags = $marketingTags;
        return $this;
    }
    /**
     * Get minimalOptionsString value
     * @return string|null
     */
    public function getMinimalOptionsString()
    {
        return $this->minimalOptionsString;
    }
    /**
     * Set minimalOptionsString value
     * @param string $minimalOptionsString
     * @return \StructType\ProductInformations
     */
    public function setMinimalOptionsString($minimalOptionsString = null)
    {
        // validation for constraint: string
        if (!is_null($minimalOptionsString) && !is_string($minimalOptionsString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimalOptionsString, true), gettype($minimalOptionsString)), __LINE__);
        }
        $this->minimalOptionsString = $minimalOptionsString;
        return $this;
    }
    /**
     * Get includedOptions value
     * @return \ArrayType\ArrayOfOption|null
     */
    public function getIncludedOptions()
    {
        return $this->includedOptions;
    }
    /**
     * Set includedOptions value
     * @param \ArrayType\ArrayOfOption $includedOptions
     * @return \StructType\ProductInformations
     */
    public function setIncludedOptions(\ArrayType\ArrayOfOption $includedOptions = null)
    {
        $this->includedOptions = $includedOptions;
        return $this;
    }
    /**
     * Get extraOptions value
     * @return \ArrayType\ArrayOfOption|null
     */
    public function getExtraOptions()
    {
        return $this->extraOptions;
    }
    /**
     * Set extraOptions value
     * @param \ArrayType\ArrayOfOption $extraOptions
     * @return \StructType\ProductInformations
     */
    public function setExtraOptions(\ArrayType\ArrayOfOption $extraOptions = null)
    {
        $this->extraOptions = $extraOptions;
        return $this;
    }
    /**
     * Get minimalOptions value
     * @return \ArrayType\ArrayOfOptionSelected|null
     */
    public function getMinimalOptions()
    {
        return $this->minimalOptions;
    }
    /**
     * Set minimalOptions value
     * @param \ArrayType\ArrayOfOptionSelected $minimalOptions
     * @return \StructType\ProductInformations
     */
    public function setMinimalOptions(\ArrayType\ArrayOfOptionSelected $minimalOptions = null)
    {
        $this->minimalOptions = $minimalOptions;
        return $this;
    }
    /**
     * Get specificCustomerOptionList value
     * @return \ArrayType\ArrayOfSpecificCustomerOption|null
     */
    public function getSpecificCustomerOptionList()
    {
        return $this->specificCustomerOptionList;
    }
    /**
     * Set specificCustomerOptionList value
     * @param \ArrayType\ArrayOfSpecificCustomerOption $specificCustomerOptionList
     * @return \StructType\ProductInformations
     */
    public function setSpecificCustomerOptionList(\ArrayType\ArrayOfSpecificCustomerOption $specificCustomerOptionList = null)
    {
        $this->specificCustomerOptionList = $specificCustomerOptionList;
        return $this;
    }
}
