<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetailedPersonFilter StructType
 * @subpackage Structs
 */
class DetailedPersonFilter extends AbstractStructBase
{
    /**
     * The PersonCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PersonCount;
    /**
     * The Age
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Age;
    /**
     * Constructor method for DetailedPersonFilter
     * @uses DetailedPersonFilter::setPersonCount()
     * @uses DetailedPersonFilter::setAge()
     * @param int $personCount
     * @param int $age
     */
    public function __construct($personCount = null, $age = null)
    {
        $this
            ->setPersonCount($personCount)
            ->setAge($age);
    }
    /**
     * Get PersonCount value
     * @return int
     */
    public function getPersonCount()
    {
        return $this->PersonCount;
    }
    /**
     * Set PersonCount value
     * @param int $personCount
     * @return \StructType\DetailedPersonFilter
     */
    public function setPersonCount($personCount = null)
    {
        // validation for constraint: int
        if (!is_null($personCount) && !(is_int($personCount) || ctype_digit($personCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($personCount, true), gettype($personCount)), __LINE__);
        }
        $this->PersonCount = $personCount;
        return $this;
    }
    /**
     * Get Age value
     * @return int
     */
    public function getAge()
    {
        return $this->Age;
    }
    /**
     * Set Age value
     * @param int $age
     * @return \StructType\DetailedPersonFilter
     */
    public function setAge($age = null)
    {
        // validation for constraint: int
        if (!is_null($age) && !(is_int($age) || ctype_digit($age))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($age, true), gettype($age)), __LINE__);
        }
        $this->Age = $age;
        return $this;
    }
}
