<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTypeHebergement ArrayType
 * @subpackage Arrays
 */
class ArrayOfTypeHebergement extends AbstractStructArrayBase
{
    /**
     * The TypeHebergement
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TypeHebergement;
    /**
     * Constructor method for ArrayOfTypeHebergement
     * @uses ArrayOfTypeHebergement::setTypeHebergement()
     * @param string[] $typeHebergement
     */
    public function __construct(array $typeHebergement = array())
    {
        $this
            ->setTypeHebergement($typeHebergement);
    }
    /**
     * Get TypeHebergement value
     * @return string[]|null
     */
    public function getTypeHebergement()
    {
        return $this->TypeHebergement;
    }
    /**
     * This method is responsible for validating the values passed to the setTypeHebergement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTypeHebergement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeHebergementForArrayConstraintsFromSetTypeHebergement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTypeHebergementTypeHebergementItem) {
            // validation for constraint: enumeration
            if (!\EnumType\TypeHebergement::valueIsValid($arrayOfTypeHebergementTypeHebergementItem)) {
                $invalidValues[] = is_object($arrayOfTypeHebergementTypeHebergementItem) ? get_class($arrayOfTypeHebergementTypeHebergementItem) : sprintf('%s(%s)', gettype($arrayOfTypeHebergementTypeHebergementItem), var_export($arrayOfTypeHebergementTypeHebergementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeHebergement', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\TypeHebergement::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TypeHebergement value
     * @uses \EnumType\TypeHebergement::valueIsValid()
     * @uses \EnumType\TypeHebergement::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $typeHebergement
     * @return \ArrayType\ArrayOfTypeHebergement
     */
    public function setTypeHebergement(array $typeHebergement = array())
    {
        // validation for constraint: array
        if ('' !== ($typeHebergementArrayErrorMessage = self::validateTypeHebergementForArrayConstraintsFromSetTypeHebergement($typeHebergement))) {
            throw new \InvalidArgumentException($typeHebergementArrayErrorMessage, __LINE__);
        }
        $this->TypeHebergement = $typeHebergement;
        return $this;
    }
    /**
     * Add item to TypeHebergement value
     * @uses \EnumType\TypeHebergement::valueIsValid()
     * @uses \EnumType\TypeHebergement::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfTypeHebergement
     */
    public function addToTypeHebergement($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeHebergement::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeHebergement', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\TypeHebergement::getValidValues())), __LINE__);
        }
        $this->TypeHebergement[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\TypeHebergement::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfTypeHebergement
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeHebergement::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeHebergement', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\TypeHebergement::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TypeHebergement
     */
    public function getAttributeName()
    {
        return 'TypeHebergement';
    }
}
