<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSubTypeProduct ArrayType
 * @subpackage Arrays
 */
class ArrayOfSubTypeProduct extends AbstractStructArrayBase
{
    /**
     * The SubTypeProduct
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SubTypeProduct[]
     */
    public $SubTypeProduct;
    /**
     * Constructor method for ArrayOfSubTypeProduct
     * @uses ArrayOfSubTypeProduct::setSubTypeProduct()
     * @param \StructType\SubTypeProduct[] $subTypeProduct
     */
    public function __construct(array $subTypeProduct = array())
    {
        $this
            ->setSubTypeProduct($subTypeProduct);
    }
    /**
     * Get SubTypeProduct value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SubTypeProduct[]|null
     */
    public function getSubTypeProduct()
    {
        return isset($this->SubTypeProduct) ? $this->SubTypeProduct : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSubTypeProduct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSubTypeProduct method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSubTypeProductForArrayConstraintsFromSetSubTypeProduct(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSubTypeProductSubTypeProductItem) {
            // validation for constraint: itemType
            if (!$arrayOfSubTypeProductSubTypeProductItem instanceof \StructType\SubTypeProduct) {
                $invalidValues[] = is_object($arrayOfSubTypeProductSubTypeProductItem) ? get_class($arrayOfSubTypeProductSubTypeProductItem) : sprintf('%s(%s)', gettype($arrayOfSubTypeProductSubTypeProductItem), var_export($arrayOfSubTypeProductSubTypeProductItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SubTypeProduct property can only contain items of type \StructType\SubTypeProduct, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SubTypeProduct value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SubTypeProduct[] $subTypeProduct
     * @return \ArrayType\ArrayOfSubTypeProduct
     */
    public function setSubTypeProduct(array $subTypeProduct = array())
    {
        // validation for constraint: array
        if ('' !== ($subTypeProductArrayErrorMessage = self::validateSubTypeProductForArrayConstraintsFromSetSubTypeProduct($subTypeProduct))) {
            throw new \InvalidArgumentException($subTypeProductArrayErrorMessage, __LINE__);
        }
        if (is_null($subTypeProduct) || (is_array($subTypeProduct) && empty($subTypeProduct))) {
            unset($this->SubTypeProduct);
        } else {
            $this->SubTypeProduct = $subTypeProduct;
        }
        return $this;
    }
    /**
     * Add item to SubTypeProduct value
     * @throws \InvalidArgumentException
     * @param \StructType\SubTypeProduct $item
     * @return \ArrayType\ArrayOfSubTypeProduct
     */
    public function addToSubTypeProduct(\StructType\SubTypeProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubTypeProduct) {
            throw new \InvalidArgumentException(sprintf('The SubTypeProduct property can only contain items of type \StructType\SubTypeProduct, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SubTypeProduct[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SubTypeProduct|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SubTypeProduct|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SubTypeProduct|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SubTypeProduct|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SubTypeProduct|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SubTypeProduct
     */
    public function getAttributeName()
    {
        return 'SubTypeProduct';
    }
}
