<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSocialUrl ArrayType
 * @subpackage Arrays
 */
class ArrayOfSocialUrl extends AbstractStructArrayBase
{
    /**
     * The SocialUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SocialUrl[]
     */
    public $SocialUrl;
    /**
     * Constructor method for ArrayOfSocialUrl
     * @uses ArrayOfSocialUrl::setSocialUrl()
     * @param \StructType\SocialUrl[] $socialUrl
     */
    public function __construct(array $socialUrl = array())
    {
        $this
            ->setSocialUrl($socialUrl);
    }
    /**
     * Get SocialUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SocialUrl[]|null
     */
    public function getSocialUrl()
    {
        return isset($this->SocialUrl) ? $this->SocialUrl : null;
    }
    /**
     * This method is responsible for validating the values passed to the setSocialUrl method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSocialUrl method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSocialUrlForArrayConstraintsFromSetSocialUrl(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfSocialUrlSocialUrlItem) {
            // validation for constraint: itemType
            if (!$arrayOfSocialUrlSocialUrlItem instanceof \StructType\SocialUrl) {
                $invalidValues[] = is_object($arrayOfSocialUrlSocialUrlItem) ? get_class($arrayOfSocialUrlSocialUrlItem) : sprintf('%s(%s)', gettype($arrayOfSocialUrlSocialUrlItem), var_export($arrayOfSocialUrlSocialUrlItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SocialUrl property can only contain items of type \StructType\SocialUrl, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SocialUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SocialUrl[] $socialUrl
     * @return \ArrayType\ArrayOfSocialUrl
     */
    public function setSocialUrl(array $socialUrl = array())
    {
        // validation for constraint: array
        if ('' !== ($socialUrlArrayErrorMessage = self::validateSocialUrlForArrayConstraintsFromSetSocialUrl($socialUrl))) {
            throw new \InvalidArgumentException($socialUrlArrayErrorMessage, __LINE__);
        }
        if (is_null($socialUrl) || (is_array($socialUrl) && empty($socialUrl))) {
            unset($this->SocialUrl);
        } else {
            $this->SocialUrl = $socialUrl;
        }
        return $this;
    }
    /**
     * Add item to SocialUrl value
     * @throws \InvalidArgumentException
     * @param \StructType\SocialUrl $item
     * @return \ArrayType\ArrayOfSocialUrl
     */
    public function addToSocialUrl(\StructType\SocialUrl $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SocialUrl) {
            throw new \InvalidArgumentException(sprintf('The SocialUrl property can only contain items of type \StructType\SocialUrl, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SocialUrl[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SocialUrl|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SocialUrl|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SocialUrl|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SocialUrl|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SocialUrl|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SocialUrl
     */
    public function getAttributeName()
    {
        return 'SocialUrl';
    }
}
