<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEstablishmentInformation ArrayType
 * @subpackage Arrays
 */
class ArrayOfEstablishmentInformation extends AbstractStructArrayBase
{
    /**
     * The establishmentInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EstablishmentInformation[]
     */
    public $establishmentInformation;
    /**
     * Constructor method for ArrayOfEstablishmentInformation
     * @uses ArrayOfEstablishmentInformation::setEstablishmentInformation()
     * @param \StructType\EstablishmentInformation[] $establishmentInformation
     */
    public function __construct(array $establishmentInformation = array())
    {
        $this
            ->setEstablishmentInformation($establishmentInformation);
    }
    /**
     * Get establishmentInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EstablishmentInformation[]|null
     */
    public function getEstablishmentInformation()
    {
        return isset($this->establishmentInformation) ? $this->establishmentInformation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEstablishmentInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEstablishmentInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEstablishmentInformationForArrayConstraintsFromSetEstablishmentInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEstablishmentInformationEstablishmentInformationItem) {
            // validation for constraint: itemType
            if (!$arrayOfEstablishmentInformationEstablishmentInformationItem instanceof \StructType\EstablishmentInformation) {
                $invalidValues[] = is_object($arrayOfEstablishmentInformationEstablishmentInformationItem) ? get_class($arrayOfEstablishmentInformationEstablishmentInformationItem) : sprintf('%s(%s)', gettype($arrayOfEstablishmentInformationEstablishmentInformationItem), var_export($arrayOfEstablishmentInformationEstablishmentInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The establishmentInformation property can only contain items of type \StructType\EstablishmentInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set establishmentInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EstablishmentInformation[] $establishmentInformation
     * @return \ArrayType\ArrayOfEstablishmentInformation
     */
    public function setEstablishmentInformation(array $establishmentInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($establishmentInformationArrayErrorMessage = self::validateEstablishmentInformationForArrayConstraintsFromSetEstablishmentInformation($establishmentInformation))) {
            throw new \InvalidArgumentException($establishmentInformationArrayErrorMessage, __LINE__);
        }
        if (is_null($establishmentInformation) || (is_array($establishmentInformation) && empty($establishmentInformation))) {
            unset($this->establishmentInformation);
        } else {
            $this->establishmentInformation = $establishmentInformation;
        }
        return $this;
    }
    /**
     * Add item to establishmentInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\EstablishmentInformation $item
     * @return \ArrayType\ArrayOfEstablishmentInformation
     */
    public function addToEstablishmentInformation(\StructType\EstablishmentInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EstablishmentInformation) {
            throw new \InvalidArgumentException(sprintf('The establishmentInformation property can only contain items of type \StructType\EstablishmentInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->establishmentInformation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EstablishmentInformation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EstablishmentInformation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EstablishmentInformation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EstablishmentInformation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EstablishmentInformation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string establishmentInformation
     */
    public function getAttributeName()
    {
        return 'establishmentInformation';
    }
}
