<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEstablishmentInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfEstablishmentInfo extends AbstractStructArrayBase
{
    /**
     * The establishmentInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EstablishmentInfo[]
     */
    public $establishmentInfo;
    /**
     * Constructor method for ArrayOfEstablishmentInfo
     * @uses ArrayOfEstablishmentInfo::setEstablishmentInfo()
     * @param \StructType\EstablishmentInfo[] $establishmentInfo
     */
    public function __construct(array $establishmentInfo = array())
    {
        $this
            ->setEstablishmentInfo($establishmentInfo);
    }
    /**
     * Get establishmentInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EstablishmentInfo[]|null
     */
    public function getEstablishmentInfo()
    {
        return isset($this->establishmentInfo) ? $this->establishmentInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEstablishmentInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEstablishmentInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEstablishmentInfoForArrayConstraintsFromSetEstablishmentInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEstablishmentInfoEstablishmentInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfEstablishmentInfoEstablishmentInfoItem instanceof \StructType\EstablishmentInfo) {
                $invalidValues[] = is_object($arrayOfEstablishmentInfoEstablishmentInfoItem) ? get_class($arrayOfEstablishmentInfoEstablishmentInfoItem) : sprintf('%s(%s)', gettype($arrayOfEstablishmentInfoEstablishmentInfoItem), var_export($arrayOfEstablishmentInfoEstablishmentInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The establishmentInfo property can only contain items of type \StructType\EstablishmentInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set establishmentInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EstablishmentInfo[] $establishmentInfo
     * @return \ArrayType\ArrayOfEstablishmentInfo
     */
    public function setEstablishmentInfo(array $establishmentInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($establishmentInfoArrayErrorMessage = self::validateEstablishmentInfoForArrayConstraintsFromSetEstablishmentInfo($establishmentInfo))) {
            throw new \InvalidArgumentException($establishmentInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($establishmentInfo) || (is_array($establishmentInfo) && empty($establishmentInfo))) {
            unset($this->establishmentInfo);
        } else {
            $this->establishmentInfo = $establishmentInfo;
        }
        return $this;
    }
    /**
     * Add item to establishmentInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\EstablishmentInfo $item
     * @return \ArrayType\ArrayOfEstablishmentInfo
     */
    public function addToEstablishmentInfo(\StructType\EstablishmentInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EstablishmentInfo) {
            throw new \InvalidArgumentException(sprintf('The establishmentInfo property can only contain items of type \StructType\EstablishmentInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->establishmentInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EstablishmentInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EstablishmentInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EstablishmentInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EstablishmentInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EstablishmentInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string establishmentInfo
     */
    public function getAttributeName()
    {
        return 'establishmentInfo';
    }
}
