<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for textInfo StructType
 * @subpackage Structs
 */
class TextInfo extends AbstractStructBase
{
    /**
     * The myTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $myTitle;
    /**
     * The myContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $myContent;
    /**
     * The myPhotos
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TextPhotoInfo[]
     */
    public $myPhotos;
    /**
     * The myContents
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $myContents;
    /**
     * The myCode
     * @var string
     */
    public $myCode;
    /**
     * Constructor method for textInfo
     * @uses TextInfo::setMyTitle()
     * @uses TextInfo::setMyContent()
     * @uses TextInfo::setMyPhotos()
     * @uses TextInfo::setMyContents()
     * @uses TextInfo::setMyCode()
     * @param string $myTitle
     * @param string $myContent
     * @param \StructType\TextPhotoInfo[] $myPhotos
     * @param string[] $myContents
     * @param string $myCode
     */
    public function __construct($myTitle = null, $myContent = null, array $myPhotos = array(), array $myContents = array(), $myCode = null)
    {
        $this
            ->setMyTitle($myTitle)
            ->setMyContent($myContent)
            ->setMyPhotos($myPhotos)
            ->setMyContents($myContents)
            ->setMyCode($myCode);
    }
    /**
     * Get myTitle value
     * @return string|null
     */
    public function getMyTitle()
    {
        return $this->myTitle;
    }
    /**
     * Set myTitle value
     * @param string $myTitle
     * @return \StructType\TextInfo
     */
    public function setMyTitle($myTitle = null)
    {
        // validation for constraint: string
        if (!is_null($myTitle) && !is_string($myTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myTitle, true), gettype($myTitle)), __LINE__);
        }
        $this->myTitle = $myTitle;
        return $this;
    }
    /**
     * Get myContent value
     * @return string|null
     */
    public function getMyContent()
    {
        return $this->myContent;
    }
    /**
     * Set myContent value
     * @param string $myContent
     * @return \StructType\TextInfo
     */
    public function setMyContent($myContent = null)
    {
        // validation for constraint: string
        if (!is_null($myContent) && !is_string($myContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myContent, true), gettype($myContent)), __LINE__);
        }
        $this->myContent = $myContent;
        return $this;
    }
    /**
     * Get myPhotos value
     * @return \StructType\TextPhotoInfo[]|null
     */
    public function getMyPhotos()
    {
        return $this->myPhotos;
    }
    /**
     * This method is responsible for validating the values passed to the setMyPhotos method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMyPhotos method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMyPhotosForArrayConstraintsFromSetMyPhotos(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $textInfoMyPhotosItem) {
            // validation for constraint: itemType
            if (!$textInfoMyPhotosItem instanceof \StructType\TextPhotoInfo) {
                $invalidValues[] = is_object($textInfoMyPhotosItem) ? get_class($textInfoMyPhotosItem) : sprintf('%s(%s)', gettype($textInfoMyPhotosItem), var_export($textInfoMyPhotosItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The myPhotos property can only contain items of type \StructType\TextPhotoInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set myPhotos value
     * @throws \InvalidArgumentException
     * @param \StructType\TextPhotoInfo[] $myPhotos
     * @return \StructType\TextInfo
     */
    public function setMyPhotos(array $myPhotos = array())
    {
        // validation for constraint: array
        if ('' !== ($myPhotosArrayErrorMessage = self::validateMyPhotosForArrayConstraintsFromSetMyPhotos($myPhotos))) {
            throw new \InvalidArgumentException($myPhotosArrayErrorMessage, __LINE__);
        }
        $this->myPhotos = $myPhotos;
        return $this;
    }
    /**
     * Add item to myPhotos value
     * @throws \InvalidArgumentException
     * @param \StructType\TextPhotoInfo $item
     * @return \StructType\TextInfo
     */
    public function addToMyPhotos(\StructType\TextPhotoInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TextPhotoInfo) {
            throw new \InvalidArgumentException(sprintf('The myPhotos property can only contain items of type \StructType\TextPhotoInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->myPhotos[] = $item;
        return $this;
    }
    /**
     * Get myContents value
     * @return string[]|null
     */
    public function getMyContents()
    {
        return $this->myContents;
    }
    /**
     * This method is responsible for validating the values passed to the setMyContents method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMyContents method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMyContentsForArrayConstraintsFromSetMyContents(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $textInfoMyContentsItem) {
            // validation for constraint: itemType
            if (!is_string($textInfoMyContentsItem)) {
                $invalidValues[] = is_object($textInfoMyContentsItem) ? get_class($textInfoMyContentsItem) : sprintf('%s(%s)', gettype($textInfoMyContentsItem), var_export($textInfoMyContentsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The myContents property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set myContents value
     * @throws \InvalidArgumentException
     * @param string[] $myContents
     * @return \StructType\TextInfo
     */
    public function setMyContents(array $myContents = array())
    {
        // validation for constraint: array
        if ('' !== ($myContentsArrayErrorMessage = self::validateMyContentsForArrayConstraintsFromSetMyContents($myContents))) {
            throw new \InvalidArgumentException($myContentsArrayErrorMessage, __LINE__);
        }
        $this->myContents = $myContents;
        return $this;
    }
    /**
     * Add item to myContents value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\TextInfo
     */
    public function addToMyContents($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The myContents property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->myContents[] = $item;
        return $this;
    }
    /**
     * Get myCode value
     * @return string|null
     */
    public function getMyCode()
    {
        return $this->myCode;
    }
    /**
     * Set myCode value
     * @param string $myCode
     * @return \StructType\TextInfo
     */
    public function setMyCode($myCode = null)
    {
        // validation for constraint: string
        if (!is_null($myCode) && !is_string($myCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myCode, true), gettype($myCode)), __LINE__);
        }
        $this->myCode = $myCode;
        return $this;
    }
}
