<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InformationPitch StructType
 * @subpackage Structs
 */
class InformationPitch extends AbstractStructBase
{
    /**
     * The Width
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Width;
    /**
     * The Length
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $Length;
    /**
     * The PitchId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt_1
     */
    public $PitchId;
    /**
     * Constructor method for InformationPitch
     * @uses InformationPitch::setWidth()
     * @uses InformationPitch::setLength()
     * @uses InformationPitch::setPitchId()
     * @param float $width
     * @param float $length
     * @param \ArrayType\ArrayOfInt_1 $pitchId
     */
    public function __construct($width = null, $length = null, \ArrayType\ArrayOfInt_1 $pitchId = null)
    {
        $this
            ->setWidth($width)
            ->setLength($length)
            ->setPitchId($pitchId);
    }
    /**
     * Get Width value
     * @return float
     */
    public function getWidth()
    {
        return $this->Width;
    }
    /**
     * Set Width value
     * @param float $width
     * @return \StructType\InformationPitch
     */
    public function setWidth($width = null)
    {
        // validation for constraint: float
        if (!is_null($width) && !(is_float($width) || is_numeric($width))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($width, true), gettype($width)), __LINE__);
        }
        $this->Width = $width;
        return $this;
    }
    /**
     * Get Length value
     * @return float
     */
    public function getLength()
    {
        return $this->Length;
    }
    /**
     * Set Length value
     * @param float $length
     * @return \StructType\InformationPitch
     */
    public function setLength($length = null)
    {
        // validation for constraint: float
        if (!is_null($length) && !(is_float($length) || is_numeric($length))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($length, true), gettype($length)), __LINE__);
        }
        $this->Length = $length;
        return $this;
    }
    /**
     * Get PitchId value
     * @return \ArrayType\ArrayOfInt_1|null
     */
    public function getPitchId()
    {
        return $this->PitchId;
    }
    /**
     * Set PitchId value
     * @param \ArrayType\ArrayOfInt_1 $pitchId
     * @return \StructType\InformationPitch
     */
    public function setPitchId(\ArrayType\ArrayOfInt_1 $pitchId = null)
    {
        $this->PitchId = $pitchId;
        return $this;
    }
}
