<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Offer StructType
 * @subpackage Structs
 */
class Offer extends AbstractStructBase
{
    /**
     * The idEstablishment
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $idEstablishment;
    /**
     * The idProduct
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $idProduct;
    /**
     * The idOffer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $idOffer;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The startDateStay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $startDateStay;
    /**
     * The endDateStay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $endDateStay;
    /**
     * The endDateOffer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $endDateOffer;
    /**
     * The normalPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $normalPrice;
    /**
     * The promoPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $promoPrice;
    /**
     * The engineDiscount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $engineDiscount;
    /**
     * The nbPersMin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nbPersMin;
    /**
     * The nbPersMax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nbPersMax;
    /**
     * The nbPers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nbPers;
    /**
     * The stock
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $stock;
    /**
     * The regularDeposit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $regularDeposit;
    /**
     * The variableDeposit
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $variableDeposit;
    /**
     * The engineId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $engineId;
    /**
     * The duration
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $duration;
    /**
     * The nbDaysBeforeClosingBook
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $nbDaysBeforeClosingBook;
    /**
     * The bookingFees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $bookingFees;
    /**
     * The PriceWithOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PriceWithOptions;
    /**
     * The OfferedOptionCount
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OfferedOptionCount;
    /**
     * The label
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $label;
    /**
     * The urlBooking
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlBooking;
    /**
     * The tac
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tac;
    /**
     * The spec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $spec;
    /**
     * The urlWebSiteRedirect
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $urlWebSiteRedirect;
    /**
     * The TagDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TagDescription;
    /**
     * The LongDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LongDescription;
    /**
     * The MinimalOptionString
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MinimalOptionString;
    /**
     * The UniqueIdentifierSpecialOffer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UniqueIdentifierSpecialOffer;
    /**
     * The engineDiscountLabel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $engineDiscountLabel;
    /**
     * Constructor method for Offer
     * @uses Offer::setIdEstablishment()
     * @uses Offer::setIdProduct()
     * @uses Offer::setIdOffer()
     * @uses Offer::setType()
     * @uses Offer::setStartDateStay()
     * @uses Offer::setEndDateStay()
     * @uses Offer::setEndDateOffer()
     * @uses Offer::setNormalPrice()
     * @uses Offer::setPromoPrice()
     * @uses Offer::setEngineDiscount()
     * @uses Offer::setNbPersMin()
     * @uses Offer::setNbPersMax()
     * @uses Offer::setNbPers()
     * @uses Offer::setStock()
     * @uses Offer::setRegularDeposit()
     * @uses Offer::setVariableDeposit()
     * @uses Offer::setEngineId()
     * @uses Offer::setDuration()
     * @uses Offer::setNbDaysBeforeClosingBook()
     * @uses Offer::setBookingFees()
     * @uses Offer::setPriceWithOptions()
     * @uses Offer::setOfferedOptionCount()
     * @uses Offer::setLabel()
     * @uses Offer::setUrlBooking()
     * @uses Offer::setTac()
     * @uses Offer::setSpec()
     * @uses Offer::setUrlWebSiteRedirect()
     * @uses Offer::setTagDescription()
     * @uses Offer::setLongDescription()
     * @uses Offer::setMinimalOptionString()
     * @uses Offer::setUniqueIdentifierSpecialOffer()
     * @uses Offer::setEngineDiscountLabel()
     * @param int $idEstablishment
     * @param int $idProduct
     * @param int $idOffer
     * @param string $type
     * @param string $startDateStay
     * @param string $endDateStay
     * @param string $endDateOffer
     * @param float $normalPrice
     * @param float $promoPrice
     * @param float $engineDiscount
     * @param int $nbPersMin
     * @param int $nbPersMax
     * @param int $nbPers
     * @param int $stock
     * @param float $regularDeposit
     * @param float $variableDeposit
     * @param int $engineId
     * @param int $duration
     * @param int $nbDaysBeforeClosingBook
     * @param float $bookingFees
     * @param float $priceWithOptions
     * @param int $offeredOptionCount
     * @param string $label
     * @param string $urlBooking
     * @param string $tac
     * @param string $spec
     * @param string $urlWebSiteRedirect
     * @param string $tagDescription
     * @param string $longDescription
     * @param string $minimalOptionString
     * @param string $uniqueIdentifierSpecialOffer
     * @param string $engineDiscountLabel
     */
    public function __construct($idEstablishment = null, $idProduct = null, $idOffer = null, $type = null, $startDateStay = null, $endDateStay = null, $endDateOffer = null, $normalPrice = null, $promoPrice = null, $engineDiscount = null, $nbPersMin = null, $nbPersMax = null, $nbPers = null, $stock = null, $regularDeposit = null, $variableDeposit = null, $engineId = null, $duration = null, $nbDaysBeforeClosingBook = null, $bookingFees = null, $priceWithOptions = null, $offeredOptionCount = null, $label = null, $urlBooking = null, $tac = null, $spec = null, $urlWebSiteRedirect = null, $tagDescription = null, $longDescription = null, $minimalOptionString = null, $uniqueIdentifierSpecialOffer = null, $engineDiscountLabel = null)
    {
        $this
            ->setIdEstablishment($idEstablishment)
            ->setIdProduct($idProduct)
            ->setIdOffer($idOffer)
            ->setType($type)
            ->setStartDateStay($startDateStay)
            ->setEndDateStay($endDateStay)
            ->setEndDateOffer($endDateOffer)
            ->setNormalPrice($normalPrice)
            ->setPromoPrice($promoPrice)
            ->setEngineDiscount($engineDiscount)
            ->setNbPersMin($nbPersMin)
            ->setNbPersMax($nbPersMax)
            ->setNbPers($nbPers)
            ->setStock($stock)
            ->setRegularDeposit($regularDeposit)
            ->setVariableDeposit($variableDeposit)
            ->setEngineId($engineId)
            ->setDuration($duration)
            ->setNbDaysBeforeClosingBook($nbDaysBeforeClosingBook)
            ->setBookingFees($bookingFees)
            ->setPriceWithOptions($priceWithOptions)
            ->setOfferedOptionCount($offeredOptionCount)
            ->setLabel($label)
            ->setUrlBooking($urlBooking)
            ->setTac($tac)
            ->setSpec($spec)
            ->setUrlWebSiteRedirect($urlWebSiteRedirect)
            ->setTagDescription($tagDescription)
            ->setLongDescription($longDescription)
            ->setMinimalOptionString($minimalOptionString)
            ->setUniqueIdentifierSpecialOffer($uniqueIdentifierSpecialOffer)
            ->setEngineDiscountLabel($engineDiscountLabel);
    }
    /**
     * Get idEstablishment value
     * @return int
     */
    public function getIdEstablishment()
    {
        return $this->idEstablishment;
    }
    /**
     * Set idEstablishment value
     * @param int $idEstablishment
     * @return \StructType\Offer
     */
    public function setIdEstablishment($idEstablishment = null)
    {
        // validation for constraint: int
        if (!is_null($idEstablishment) && !(is_int($idEstablishment) || ctype_digit($idEstablishment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idEstablishment, true), gettype($idEstablishment)), __LINE__);
        }
        $this->idEstablishment = $idEstablishment;
        return $this;
    }
    /**
     * Get idProduct value
     * @return int
     */
    public function getIdProduct()
    {
        return $this->idProduct;
    }
    /**
     * Set idProduct value
     * @param int $idProduct
     * @return \StructType\Offer
     */
    public function setIdProduct($idProduct = null)
    {
        // validation for constraint: int
        if (!is_null($idProduct) && !(is_int($idProduct) || ctype_digit($idProduct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idProduct, true), gettype($idProduct)), __LINE__);
        }
        $this->idProduct = $idProduct;
        return $this;
    }
    /**
     * Get idOffer value
     * @return int
     */
    public function getIdOffer()
    {
        return $this->idOffer;
    }
    /**
     * Set idOffer value
     * @param int $idOffer
     * @return \StructType\Offer
     */
    public function setIdOffer($idOffer = null)
    {
        // validation for constraint: int
        if (!is_null($idOffer) && !(is_int($idOffer) || ctype_digit($idOffer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idOffer, true), gettype($idOffer)), __LINE__);
        }
        $this->idOffer = $idOffer;
        return $this;
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\DmTypeEnum::valueIsValid()
     * @uses \EnumType\DmTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Offer
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DmTypeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DmTypeEnum', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\DmTypeEnum::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get startDateStay value
     * @return string
     */
    public function getStartDateStay()
    {
        return $this->startDateStay;
    }
    /**
     * Set startDateStay value
     * @param string $startDateStay
     * @return \StructType\Offer
     */
    public function setStartDateStay($startDateStay = null)
    {
        // validation for constraint: string
        if (!is_null($startDateStay) && !is_string($startDateStay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDateStay, true), gettype($startDateStay)), __LINE__);
        }
        $this->startDateStay = $startDateStay;
        return $this;
    }
    /**
     * Get endDateStay value
     * @return string
     */
    public function getEndDateStay()
    {
        return $this->endDateStay;
    }
    /**
     * Set endDateStay value
     * @param string $endDateStay
     * @return \StructType\Offer
     */
    public function setEndDateStay($endDateStay = null)
    {
        // validation for constraint: string
        if (!is_null($endDateStay) && !is_string($endDateStay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDateStay, true), gettype($endDateStay)), __LINE__);
        }
        $this->endDateStay = $endDateStay;
        return $this;
    }
    /**
     * Get endDateOffer value
     * @return string
     */
    public function getEndDateOffer()
    {
        return $this->endDateOffer;
    }
    /**
     * Set endDateOffer value
     * @param string $endDateOffer
     * @return \StructType\Offer
     */
    public function setEndDateOffer($endDateOffer = null)
    {
        // validation for constraint: string
        if (!is_null($endDateOffer) && !is_string($endDateOffer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDateOffer, true), gettype($endDateOffer)), __LINE__);
        }
        $this->endDateOffer = $endDateOffer;
        return $this;
    }
    /**
     * Get normalPrice value
     * @return float
     */
    public function getNormalPrice()
    {
        return $this->normalPrice;
    }
    /**
     * Set normalPrice value
     * @param float $normalPrice
     * @return \StructType\Offer
     */
    public function setNormalPrice($normalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($normalPrice) && !(is_float($normalPrice) || is_numeric($normalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($normalPrice, true), gettype($normalPrice)), __LINE__);
        }
        $this->normalPrice = $normalPrice;
        return $this;
    }
    /**
     * Get promoPrice value
     * @return float
     */
    public function getPromoPrice()
    {
        return $this->promoPrice;
    }
    /**
     * Set promoPrice value
     * @param float $promoPrice
     * @return \StructType\Offer
     */
    public function setPromoPrice($promoPrice = null)
    {
        // validation for constraint: float
        if (!is_null($promoPrice) && !(is_float($promoPrice) || is_numeric($promoPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($promoPrice, true), gettype($promoPrice)), __LINE__);
        }
        $this->promoPrice = $promoPrice;
        return $this;
    }
    /**
     * Get engineDiscount value
     * @return float
     */
    public function getEngineDiscount()
    {
        return $this->engineDiscount;
    }
    /**
     * Set engineDiscount value
     * @param float $engineDiscount
     * @return \StructType\Offer
     */
    public function setEngineDiscount($engineDiscount = null)
    {
        // validation for constraint: float
        if (!is_null($engineDiscount) && !(is_float($engineDiscount) || is_numeric($engineDiscount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($engineDiscount, true), gettype($engineDiscount)), __LINE__);
        }
        $this->engineDiscount = $engineDiscount;
        return $this;
    }
    /**
     * Get nbPersMin value
     * @return int
     */
    public function getNbPersMin()
    {
        return $this->nbPersMin;
    }
    /**
     * Set nbPersMin value
     * @param int $nbPersMin
     * @return \StructType\Offer
     */
    public function setNbPersMin($nbPersMin = null)
    {
        // validation for constraint: int
        if (!is_null($nbPersMin) && !(is_int($nbPersMin) || ctype_digit($nbPersMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbPersMin, true), gettype($nbPersMin)), __LINE__);
        }
        $this->nbPersMin = $nbPersMin;
        return $this;
    }
    /**
     * Get nbPersMax value
     * @return int
     */
    public function getNbPersMax()
    {
        return $this->nbPersMax;
    }
    /**
     * Set nbPersMax value
     * @param int $nbPersMax
     * @return \StructType\Offer
     */
    public function setNbPersMax($nbPersMax = null)
    {
        // validation for constraint: int
        if (!is_null($nbPersMax) && !(is_int($nbPersMax) || ctype_digit($nbPersMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbPersMax, true), gettype($nbPersMax)), __LINE__);
        }
        $this->nbPersMax = $nbPersMax;
        return $this;
    }
    /**
     * Get nbPers value
     * @return int
     */
    public function getNbPers()
    {
        return $this->nbPers;
    }
    /**
     * Set nbPers value
     * @param int $nbPers
     * @return \StructType\Offer
     */
    public function setNbPers($nbPers = null)
    {
        // validation for constraint: int
        if (!is_null($nbPers) && !(is_int($nbPers) || ctype_digit($nbPers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbPers, true), gettype($nbPers)), __LINE__);
        }
        $this->nbPers = $nbPers;
        return $this;
    }
    /**
     * Get stock value
     * @return int
     */
    public function getStock()
    {
        return $this->stock;
    }
    /**
     * Set stock value
     * @param int $stock
     * @return \StructType\Offer
     */
    public function setStock($stock = null)
    {
        // validation for constraint: int
        if (!is_null($stock) && !(is_int($stock) || ctype_digit($stock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stock, true), gettype($stock)), __LINE__);
        }
        $this->stock = $stock;
        return $this;
    }
    /**
     * Get regularDeposit value
     * @return float
     */
    public function getRegularDeposit()
    {
        return $this->regularDeposit;
    }
    /**
     * Set regularDeposit value
     * @param float $regularDeposit
     * @return \StructType\Offer
     */
    public function setRegularDeposit($regularDeposit = null)
    {
        // validation for constraint: float
        if (!is_null($regularDeposit) && !(is_float($regularDeposit) || is_numeric($regularDeposit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($regularDeposit, true), gettype($regularDeposit)), __LINE__);
        }
        $this->regularDeposit = $regularDeposit;
        return $this;
    }
    /**
     * Get variableDeposit value
     * @return float
     */
    public function getVariableDeposit()
    {
        return $this->variableDeposit;
    }
    /**
     * Set variableDeposit value
     * @param float $variableDeposit
     * @return \StructType\Offer
     */
    public function setVariableDeposit($variableDeposit = null)
    {
        // validation for constraint: float
        if (!is_null($variableDeposit) && !(is_float($variableDeposit) || is_numeric($variableDeposit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($variableDeposit, true), gettype($variableDeposit)), __LINE__);
        }
        $this->variableDeposit = $variableDeposit;
        return $this;
    }
    /**
     * Get engineId value
     * @return int
     */
    public function getEngineId()
    {
        return $this->engineId;
    }
    /**
     * Set engineId value
     * @param int $engineId
     * @return \StructType\Offer
     */
    public function setEngineId($engineId = null)
    {
        // validation for constraint: int
        if (!is_null($engineId) && !(is_int($engineId) || ctype_digit($engineId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($engineId, true), gettype($engineId)), __LINE__);
        }
        $this->engineId = $engineId;
        return $this;
    }
    /**
     * Get duration value
     * @return int
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param int $duration
     * @return \StructType\Offer
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get nbDaysBeforeClosingBook value
     * @return int
     */
    public function getNbDaysBeforeClosingBook()
    {
        return $this->nbDaysBeforeClosingBook;
    }
    /**
     * Set nbDaysBeforeClosingBook value
     * @param int $nbDaysBeforeClosingBook
     * @return \StructType\Offer
     */
    public function setNbDaysBeforeClosingBook($nbDaysBeforeClosingBook = null)
    {
        // validation for constraint: int
        if (!is_null($nbDaysBeforeClosingBook) && !(is_int($nbDaysBeforeClosingBook) || ctype_digit($nbDaysBeforeClosingBook))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbDaysBeforeClosingBook, true), gettype($nbDaysBeforeClosingBook)), __LINE__);
        }
        $this->nbDaysBeforeClosingBook = $nbDaysBeforeClosingBook;
        return $this;
    }
    /**
     * Get bookingFees value
     * @return float
     */
    public function getBookingFees()
    {
        return $this->bookingFees;
    }
    /**
     * Set bookingFees value
     * @param float $bookingFees
     * @return \StructType\Offer
     */
    public function setBookingFees($bookingFees = null)
    {
        // validation for constraint: float
        if (!is_null($bookingFees) && !(is_float($bookingFees) || is_numeric($bookingFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bookingFees, true), gettype($bookingFees)), __LINE__);
        }
        $this->bookingFees = $bookingFees;
        return $this;
    }
    /**
     * Get PriceWithOptions value
     * @return float
     */
    public function getPriceWithOptions()
    {
        return $this->PriceWithOptions;
    }
    /**
     * Set PriceWithOptions value
     * @param float $priceWithOptions
     * @return \StructType\Offer
     */
    public function setPriceWithOptions($priceWithOptions = null)
    {
        // validation for constraint: float
        if (!is_null($priceWithOptions) && !(is_float($priceWithOptions) || is_numeric($priceWithOptions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceWithOptions, true), gettype($priceWithOptions)), __LINE__);
        }
        $this->PriceWithOptions = $priceWithOptions;
        return $this;
    }
    /**
     * Get OfferedOptionCount value
     * @return int
     */
    public function getOfferedOptionCount()
    {
        return $this->OfferedOptionCount;
    }
    /**
     * Set OfferedOptionCount value
     * @param int $offeredOptionCount
     * @return \StructType\Offer
     */
    public function setOfferedOptionCount($offeredOptionCount = null)
    {
        // validation for constraint: int
        if (!is_null($offeredOptionCount) && !(is_int($offeredOptionCount) || ctype_digit($offeredOptionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($offeredOptionCount, true), gettype($offeredOptionCount)), __LINE__);
        }
        $this->OfferedOptionCount = $offeredOptionCount;
        return $this;
    }
    /**
     * Get label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->label;
    }
    /**
     * Set label value
     * @param string $label
     * @return \StructType\Offer
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->label = $label;
        return $this;
    }
    /**
     * Get urlBooking value
     * @return string|null
     */
    public function getUrlBooking()
    {
        return $this->urlBooking;
    }
    /**
     * Set urlBooking value
     * @param string $urlBooking
     * @return \StructType\Offer
     */
    public function setUrlBooking($urlBooking = null)
    {
        // validation for constraint: string
        if (!is_null($urlBooking) && !is_string($urlBooking)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlBooking, true), gettype($urlBooking)), __LINE__);
        }
        $this->urlBooking = $urlBooking;
        return $this;
    }
    /**
     * Get tac value
     * @return string|null
     */
    public function getTac()
    {
        return $this->tac;
    }
    /**
     * Set tac value
     * @param string $tac
     * @return \StructType\Offer
     */
    public function setTac($tac = null)
    {
        // validation for constraint: string
        if (!is_null($tac) && !is_string($tac)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tac, true), gettype($tac)), __LINE__);
        }
        $this->tac = $tac;
        return $this;
    }
    /**
     * Get spec value
     * @return string|null
     */
    public function getSpec()
    {
        return $this->spec;
    }
    /**
     * Set spec value
     * @param string $spec
     * @return \StructType\Offer
     */
    public function setSpec($spec = null)
    {
        // validation for constraint: string
        if (!is_null($spec) && !is_string($spec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spec, true), gettype($spec)), __LINE__);
        }
        $this->spec = $spec;
        return $this;
    }
    /**
     * Get urlWebSiteRedirect value
     * @return string|null
     */
    public function getUrlWebSiteRedirect()
    {
        return $this->urlWebSiteRedirect;
    }
    /**
     * Set urlWebSiteRedirect value
     * @param string $urlWebSiteRedirect
     * @return \StructType\Offer
     */
    public function setUrlWebSiteRedirect($urlWebSiteRedirect = null)
    {
        // validation for constraint: string
        if (!is_null($urlWebSiteRedirect) && !is_string($urlWebSiteRedirect)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlWebSiteRedirect, true), gettype($urlWebSiteRedirect)), __LINE__);
        }
        $this->urlWebSiteRedirect = $urlWebSiteRedirect;
        return $this;
    }
    /**
     * Get TagDescription value
     * @return string|null
     */
    public function getTagDescription()
    {
        return $this->TagDescription;
    }
    /**
     * Set TagDescription value
     * @param string $tagDescription
     * @return \StructType\Offer
     */
    public function setTagDescription($tagDescription = null)
    {
        // validation for constraint: string
        if (!is_null($tagDescription) && !is_string($tagDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tagDescription, true), gettype($tagDescription)), __LINE__);
        }
        $this->TagDescription = $tagDescription;
        return $this;
    }
    /**
     * Get LongDescription value
     * @return string|null
     */
    public function getLongDescription()
    {
        return $this->LongDescription;
    }
    /**
     * Set LongDescription value
     * @param string $longDescription
     * @return \StructType\Offer
     */
    public function setLongDescription($longDescription = null)
    {
        // validation for constraint: string
        if (!is_null($longDescription) && !is_string($longDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($longDescription, true), gettype($longDescription)), __LINE__);
        }
        $this->LongDescription = $longDescription;
        return $this;
    }
    /**
     * Get MinimalOptionString value
     * @return string|null
     */
    public function getMinimalOptionString()
    {
        return $this->MinimalOptionString;
    }
    /**
     * Set MinimalOptionString value
     * @param string $minimalOptionString
     * @return \StructType\Offer
     */
    public function setMinimalOptionString($minimalOptionString = null)
    {
        // validation for constraint: string
        if (!is_null($minimalOptionString) && !is_string($minimalOptionString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimalOptionString, true), gettype($minimalOptionString)), __LINE__);
        }
        $this->MinimalOptionString = $minimalOptionString;
        return $this;
    }
    /**
     * Get UniqueIdentifierSpecialOffer value
     * @return string|null
     */
    public function getUniqueIdentifierSpecialOffer()
    {
        return $this->UniqueIdentifierSpecialOffer;
    }
    /**
     * Set UniqueIdentifierSpecialOffer value
     * @param string $uniqueIdentifierSpecialOffer
     * @return \StructType\Offer
     */
    public function setUniqueIdentifierSpecialOffer($uniqueIdentifierSpecialOffer = null)
    {
        // validation for constraint: string
        if (!is_null($uniqueIdentifierSpecialOffer) && !is_string($uniqueIdentifierSpecialOffer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uniqueIdentifierSpecialOffer, true), gettype($uniqueIdentifierSpecialOffer)), __LINE__);
        }
        $this->UniqueIdentifierSpecialOffer = $uniqueIdentifierSpecialOffer;
        return $this;
    }
    /**
     * Get engineDiscountLabel value
     * @return string|null
     */
    public function getEngineDiscountLabel()
    {
        return $this->engineDiscountLabel;
    }
    /**
     * Set engineDiscountLabel value
     * @param string $engineDiscountLabel
     * @return \StructType\Offer
     */
    public function setEngineDiscountLabel($engineDiscountLabel = null)
    {
        // validation for constraint: string
        if (!is_null($engineDiscountLabel) && !is_string($engineDiscountLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($engineDiscountLabel, true), gettype($engineDiscountLabel)), __LINE__);
        }
        $this->engineDiscountLabel = $engineDiscountLabel;
        return $this;
    }
}
