<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPeriod ArrayType
 * @subpackage Arrays
 */
class ArrayOfPeriod extends AbstractStructArrayBase
{
    /**
     * The Period
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Period[]
     */
    public $Period;
    /**
     * Constructor method for ArrayOfPeriod
     * @uses ArrayOfPeriod::setPeriod()
     * @param \StructType\Period[] $period
     */
    public function __construct(array $period = array())
    {
        $this
            ->setPeriod($period);
    }
    /**
     * Get Period value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Period[]|null
     */
    public function getPeriod()
    {
        return isset($this->Period) ? $this->Period : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPeriod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPeriod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePeriodForArrayConstraintsFromSetPeriod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPeriodPeriodItem) {
            // validation for constraint: itemType
            if (!$arrayOfPeriodPeriodItem instanceof \StructType\Period) {
                $invalidValues[] = is_object($arrayOfPeriodPeriodItem) ? get_class($arrayOfPeriodPeriodItem) : sprintf('%s(%s)', gettype($arrayOfPeriodPeriodItem), var_export($arrayOfPeriodPeriodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Period property can only contain items of type \StructType\Period, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Period value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Period[] $period
     * @return \ArrayType\ArrayOfPeriod
     */
    public function setPeriod(array $period = array())
    {
        // validation for constraint: array
        if ('' !== ($periodArrayErrorMessage = self::validatePeriodForArrayConstraintsFromSetPeriod($period))) {
            throw new \InvalidArgumentException($periodArrayErrorMessage, __LINE__);
        }
        if (is_null($period) || (is_array($period) && empty($period))) {
            unset($this->Period);
        } else {
            $this->Period = $period;
        }
        return $this;
    }
    /**
     * Add item to Period value
     * @throws \InvalidArgumentException
     * @param \StructType\Period $item
     * @return \ArrayType\ArrayOfPeriod
     */
    public function addToPeriod(\StructType\Period $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Period) {
            throw new \InvalidArgumentException(sprintf('The Period property can only contain items of type \StructType\Period, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Period[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Period|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Period|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Period|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Period|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Period|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Period
     */
    public function getAttributeName()
    {
        return 'Period';
    }
}
