<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for engineSpecialOffer StructType
 * @subpackage Structs
 */
class EngineSpecialOffer extends AbstractStructBase
{
    /**
     * The OS_engineReduction
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OS_engineReduction;
    /**
     * The OS_engineDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OS_engineDescription;
    /**
     * Constructor method for engineSpecialOffer
     * @uses EngineSpecialOffer::setOS_engineReduction()
     * @uses EngineSpecialOffer::setOS_engineDescription()
     * @param float $oS_engineReduction
     * @param string $oS_engineDescription
     */
    public function __construct($oS_engineReduction = null, $oS_engineDescription = null)
    {
        $this
            ->setOS_engineReduction($oS_engineReduction)
            ->setOS_engineDescription($oS_engineDescription);
    }
    /**
     * Get OS_engineReduction value
     * @return float
     */
    public function getOS_engineReduction()
    {
        return $this->OS_engineReduction;
    }
    /**
     * Set OS_engineReduction value
     * @param float $oS_engineReduction
     * @return \StructType\EngineSpecialOffer
     */
    public function setOS_engineReduction($oS_engineReduction = null)
    {
        // validation for constraint: float
        if (!is_null($oS_engineReduction) && !(is_float($oS_engineReduction) || is_numeric($oS_engineReduction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($oS_engineReduction, true), gettype($oS_engineReduction)), __LINE__);
        }
        $this->OS_engineReduction = $oS_engineReduction;
        return $this;
    }
    /**
     * Get OS_engineDescription value
     * @return string|null
     */
    public function getOS_engineDescription()
    {
        return $this->OS_engineDescription;
    }
    /**
     * Set OS_engineDescription value
     * @param string $oS_engineDescription
     * @return \StructType\EngineSpecialOffer
     */
    public function setOS_engineDescription($oS_engineDescription = null)
    {
        // validation for constraint: string
        if (!is_null($oS_engineDescription) && !is_string($oS_engineDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oS_engineDescription, true), gettype($oS_engineDescription)), __LINE__);
        }
        $this->OS_engineDescription = $oS_engineDescription;
        return $this;
    }
}
