<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TunnelAccompanyingPerson StructType
 * @subpackage Structs
 */
class TunnelAccompanyingPerson extends AbstractStructBase
{
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $BirthDate;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FirstName;
    /**
     * The CityOfBirth
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CityOfBirth;
    /**
     * The NationalityIsoCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NationalityIsoCode;
    /**
     * Constructor method for TunnelAccompanyingPerson
     * @uses TunnelAccompanyingPerson::setBirthDate()
     * @uses TunnelAccompanyingPerson::setName()
     * @uses TunnelAccompanyingPerson::setFirstName()
     * @uses TunnelAccompanyingPerson::setCityOfBirth()
     * @uses TunnelAccompanyingPerson::setNationalityIsoCode()
     * @param string $birthDate
     * @param string $name
     * @param string $firstName
     * @param string $cityOfBirth
     * @param string $nationalityIsoCode
     */
    public function __construct($birthDate = null, $name = null, $firstName = null, $cityOfBirth = null, $nationalityIsoCode = null)
    {
        $this
            ->setBirthDate($birthDate)
            ->setName($name)
            ->setFirstName($firstName)
            ->setCityOfBirth($cityOfBirth)
            ->setNationalityIsoCode($nationalityIsoCode);
    }
    /**
     * Get BirthDate value
     * @return string
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\TunnelAccompanyingPerson
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\TunnelAccompanyingPerson
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get FirstName value
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->FirstName;
    }
    /**
     * Set FirstName value
     * @param string $firstName
     * @return \StructType\TunnelAccompanyingPerson
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        $this->FirstName = $firstName;
        return $this;
    }
    /**
     * Get CityOfBirth value
     * @return string|null
     */
    public function getCityOfBirth()
    {
        return $this->CityOfBirth;
    }
    /**
     * Set CityOfBirth value
     * @param string $cityOfBirth
     * @return \StructType\TunnelAccompanyingPerson
     */
    public function setCityOfBirth($cityOfBirth = null)
    {
        // validation for constraint: string
        if (!is_null($cityOfBirth) && !is_string($cityOfBirth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityOfBirth, true), gettype($cityOfBirth)), __LINE__);
        }
        $this->CityOfBirth = $cityOfBirth;
        return $this;
    }
    /**
     * Get NationalityIsoCode value
     * @return string|null
     */
    public function getNationalityIsoCode()
    {
        return $this->NationalityIsoCode;
    }
    /**
     * Set NationalityIsoCode value
     * @param string $nationalityIsoCode
     * @return \StructType\TunnelAccompanyingPerson
     */
    public function setNationalityIsoCode($nationalityIsoCode = null)
    {
        // validation for constraint: string
        if (!is_null($nationalityIsoCode) && !is_string($nationalityIsoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalityIsoCode, true), gettype($nationalityIsoCode)), __LINE__);
        }
        $this->NationalityIsoCode = $nationalityIsoCode;
        return $this;
    }
}
