<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for thematicInfo StructType
 * @subpackage Structs
 */
class ThematicInfo extends AbstractStructBase
{
    /**
     * The myKey
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $myKey;
    /**
     * The myTitle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $myTitle;
    /**
     * The myContent
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $myContent;
    /**
     * The myTexts
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTextInfo
     */
    public $myTexts;
    /**
     * The myIsoLanguageCode
     * @var string
     */
    public $myIsoLanguageCode;
    /**
     * Constructor method for thematicInfo
     * @uses ThematicInfo::setMyKey()
     * @uses ThematicInfo::setMyTitle()
     * @uses ThematicInfo::setMyContent()
     * @uses ThematicInfo::setMyTexts()
     * @uses ThematicInfo::setMyIsoLanguageCode()
     * @param int $myKey
     * @param string $myTitle
     * @param string $myContent
     * @param \ArrayType\ArrayOfTextInfo $myTexts
     * @param string $myIsoLanguageCode
     */
    public function __construct($myKey = null, $myTitle = null, $myContent = null, \ArrayType\ArrayOfTextInfo $myTexts = null, $myIsoLanguageCode = null)
    {
        $this
            ->setMyKey($myKey)
            ->setMyTitle($myTitle)
            ->setMyContent($myContent)
            ->setMyTexts($myTexts)
            ->setMyIsoLanguageCode($myIsoLanguageCode);
    }
    /**
     * Get myKey value
     * @return int
     */
    public function getMyKey()
    {
        return $this->myKey;
    }
    /**
     * Set myKey value
     * @param int $myKey
     * @return \StructType\ThematicInfo
     */
    public function setMyKey($myKey = null)
    {
        // validation for constraint: int
        if (!is_null($myKey) && !(is_int($myKey) || ctype_digit($myKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($myKey, true), gettype($myKey)), __LINE__);
        }
        $this->myKey = $myKey;
        return $this;
    }
    /**
     * Get myTitle value
     * @return string|null
     */
    public function getMyTitle()
    {
        return $this->myTitle;
    }
    /**
     * Set myTitle value
     * @param string $myTitle
     * @return \StructType\ThematicInfo
     */
    public function setMyTitle($myTitle = null)
    {
        // validation for constraint: string
        if (!is_null($myTitle) && !is_string($myTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myTitle, true), gettype($myTitle)), __LINE__);
        }
        $this->myTitle = $myTitle;
        return $this;
    }
    /**
     * Get myContent value
     * @return string|null
     */
    public function getMyContent()
    {
        return $this->myContent;
    }
    /**
     * Set myContent value
     * @param string $myContent
     * @return \StructType\ThematicInfo
     */
    public function setMyContent($myContent = null)
    {
        // validation for constraint: string
        if (!is_null($myContent) && !is_string($myContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myContent, true), gettype($myContent)), __LINE__);
        }
        $this->myContent = $myContent;
        return $this;
    }
    /**
     * Get myTexts value
     * @return \ArrayType\ArrayOfTextInfo|null
     */
    public function getMyTexts()
    {
        return $this->myTexts;
    }
    /**
     * Set myTexts value
     * @param \ArrayType\ArrayOfTextInfo $myTexts
     * @return \StructType\ThematicInfo
     */
    public function setMyTexts(\ArrayType\ArrayOfTextInfo $myTexts = null)
    {
        $this->myTexts = $myTexts;
        return $this;
    }
    /**
     * Get myIsoLanguageCode value
     * @return string|null
     */
    public function getMyIsoLanguageCode()
    {
        return $this->myIsoLanguageCode;
    }
    /**
     * Set myIsoLanguageCode value
     * @param string $myIsoLanguageCode
     * @return \StructType\ThematicInfo
     */
    public function setMyIsoLanguageCode($myIsoLanguageCode = null)
    {
        // validation for constraint: string
        if (!is_null($myIsoLanguageCode) && !is_string($myIsoLanguageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myIsoLanguageCode, true), gettype($myIsoLanguageCode)), __LINE__);
        }
        $this->myIsoLanguageCode = $myIsoLanguageCode;
        return $this;
    }
}
