<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Stars StructType
 * @subpackage Structs
 */
class Stars extends AbstractStructBase
{
    /**
     * The number
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $number;
    /**
     * The nboffers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $nboffers;
    /**
     * Constructor method for Stars
     * @uses Stars::setNumber()
     * @uses Stars::setNboffers()
     * @param int $number
     * @param int $nboffers
     */
    public function __construct($number = null, $nboffers = null)
    {
        $this
            ->setNumber($number)
            ->setNboffers($nboffers);
    }
    /**
     * Get number value
     * @return int
     */
    public function getNumber()
    {
        return $this->number;
    }
    /**
     * Set number value
     * @param int $number
     * @return \StructType\Stars
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->number = $number;
        return $this;
    }
    /**
     * Get nboffers value
     * @return int
     */
    public function getNboffers()
    {
        return $this->nboffers;
    }
    /**
     * Set nboffers value
     * @param int $nboffers
     * @return \StructType\Stars
     */
    public function setNboffers($nboffers = null)
    {
        // validation for constraint: int
        if (!is_null($nboffers) && !(is_int($nboffers) || ctype_digit($nboffers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nboffers, true), gettype($nboffers)), __LINE__);
        }
        $this->nboffers = $nboffers;
        return $this;
    }
}
