<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productInfo StructType
 * @subpackage Structs
 */
class ProductInfo extends BaseEntityInfo
{
    /**
     * The mySortNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $mySortNumber;
    /**
     * The myLastUpdateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $myLastUpdateTime;
    /**
     * The myLastUpdateTimeForInventory
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $myLastUpdateTimeForInventory;
    /**
     * The myKeySH
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $myKeySH;
    /**
     * The active
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $active;
    /**
     * The myAccommodationTypeKey
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $myAccommodationTypeKey;
    /**
     * The myProductType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $myProductType;
    /**
     * The myInventory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemInfo[]
     */
    public $myInventory;
    /**
     * The myNumberOfPersonMinMax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $myNumberOfPersonMinMax;
    /**
     * The myFreeText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $myFreeText;
    /**
     * The myAccommodationType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $myAccommodationType;
    /**
     * The myFullName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $myFullName;
    /**
     * The myMarketingTags
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MarketingTag[]
     */
    public $myMarketingTags;
    /**
     * Constructor method for productInfo
     * @uses ProductInfo::setMySortNumber()
     * @uses ProductInfo::setMyLastUpdateTime()
     * @uses ProductInfo::setMyLastUpdateTimeForInventory()
     * @uses ProductInfo::setMyKeySH()
     * @uses ProductInfo::setActive()
     * @uses ProductInfo::setMyAccommodationTypeKey()
     * @uses ProductInfo::setMyProductType()
     * @uses ProductInfo::setMyInventory()
     * @uses ProductInfo::setMyNumberOfPersonMinMax()
     * @uses ProductInfo::setMyFreeText()
     * @uses ProductInfo::setMyAccommodationType()
     * @uses ProductInfo::setMyFullName()
     * @uses ProductInfo::setMyMarketingTags()
     * @param int $mySortNumber
     * @param string $myLastUpdateTime
     * @param string $myLastUpdateTimeForInventory
     * @param int $myKeySH
     * @param bool $active
     * @param int $myAccommodationTypeKey
     * @param string $myProductType
     * @param \StructType\ItemInfo[] $myInventory
     * @param string $myNumberOfPersonMinMax
     * @param string $myFreeText
     * @param string $myAccommodationType
     * @param string $myFullName
     * @param \StructType\MarketingTag[] $myMarketingTags
     */
    public function __construct($mySortNumber = null, $myLastUpdateTime = null, $myLastUpdateTimeForInventory = null, $myKeySH = null, $active = null, $myAccommodationTypeKey = null, $myProductType = null, array $myInventory = array(), $myNumberOfPersonMinMax = null, $myFreeText = null, $myAccommodationType = null, $myFullName = null, array $myMarketingTags = array())
    {
        $this
            ->setMySortNumber($mySortNumber)
            ->setMyLastUpdateTime($myLastUpdateTime)
            ->setMyLastUpdateTimeForInventory($myLastUpdateTimeForInventory)
            ->setMyKeySH($myKeySH)
            ->setActive($active)
            ->setMyAccommodationTypeKey($myAccommodationTypeKey)
            ->setMyProductType($myProductType)
            ->setMyInventory($myInventory)
            ->setMyNumberOfPersonMinMax($myNumberOfPersonMinMax)
            ->setMyFreeText($myFreeText)
            ->setMyAccommodationType($myAccommodationType)
            ->setMyFullName($myFullName)
            ->setMyMarketingTags($myMarketingTags);
    }
    /**
     * Get mySortNumber value
     * @return int
     */
    public function getMySortNumber()
    {
        return $this->mySortNumber;
    }
    /**
     * Set mySortNumber value
     * @param int $mySortNumber
     * @return \StructType\ProductInfo
     */
    public function setMySortNumber($mySortNumber = null)
    {
        // validation for constraint: int
        if (!is_null($mySortNumber) && !(is_int($mySortNumber) || ctype_digit($mySortNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mySortNumber, true), gettype($mySortNumber)), __LINE__);
        }
        $this->mySortNumber = $mySortNumber;
        return $this;
    }
    /**
     * Get myLastUpdateTime value
     * @return string
     */
    public function getMyLastUpdateTime()
    {
        return $this->myLastUpdateTime;
    }
    /**
     * Set myLastUpdateTime value
     * @param string $myLastUpdateTime
     * @return \StructType\ProductInfo
     */
    public function setMyLastUpdateTime($myLastUpdateTime = null)
    {
        // validation for constraint: string
        if (!is_null($myLastUpdateTime) && !is_string($myLastUpdateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myLastUpdateTime, true), gettype($myLastUpdateTime)), __LINE__);
        }
        $this->myLastUpdateTime = $myLastUpdateTime;
        return $this;
    }
    /**
     * Get myLastUpdateTimeForInventory value
     * @return string
     */
    public function getMyLastUpdateTimeForInventory()
    {
        return $this->myLastUpdateTimeForInventory;
    }
    /**
     * Set myLastUpdateTimeForInventory value
     * @param string $myLastUpdateTimeForInventory
     * @return \StructType\ProductInfo
     */
    public function setMyLastUpdateTimeForInventory($myLastUpdateTimeForInventory = null)
    {
        // validation for constraint: string
        if (!is_null($myLastUpdateTimeForInventory) && !is_string($myLastUpdateTimeForInventory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myLastUpdateTimeForInventory, true), gettype($myLastUpdateTimeForInventory)), __LINE__);
        }
        $this->myLastUpdateTimeForInventory = $myLastUpdateTimeForInventory;
        return $this;
    }
    /**
     * Get myKeySH value
     * @return int
     */
    public function getMyKeySH()
    {
        return $this->myKeySH;
    }
    /**
     * Set myKeySH value
     * @param int $myKeySH
     * @return \StructType\ProductInfo
     */
    public function setMyKeySH($myKeySH = null)
    {
        // validation for constraint: int
        if (!is_null($myKeySH) && !(is_int($myKeySH) || ctype_digit($myKeySH))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($myKeySH, true), gettype($myKeySH)), __LINE__);
        }
        $this->myKeySH = $myKeySH;
        return $this;
    }
    /**
     * Get active value
     * @return bool
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param bool $active
     * @return \StructType\ProductInfo
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get myAccommodationTypeKey value
     * @return int
     */
    public function getMyAccommodationTypeKey()
    {
        return $this->myAccommodationTypeKey;
    }
    /**
     * Set myAccommodationTypeKey value
     * @param int $myAccommodationTypeKey
     * @return \StructType\ProductInfo
     */
    public function setMyAccommodationTypeKey($myAccommodationTypeKey = null)
    {
        // validation for constraint: int
        if (!is_null($myAccommodationTypeKey) && !(is_int($myAccommodationTypeKey) || ctype_digit($myAccommodationTypeKey))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($myAccommodationTypeKey, true), gettype($myAccommodationTypeKey)), __LINE__);
        }
        $this->myAccommodationTypeKey = $myAccommodationTypeKey;
        return $this;
    }
    /**
     * Get myProductType value
     * @return string|null
     */
    public function getMyProductType()
    {
        return $this->myProductType;
    }
    /**
     * Set myProductType value
     * @param string $myProductType
     * @return \StructType\ProductInfo
     */
    public function setMyProductType($myProductType = null)
    {
        // validation for constraint: string
        if (!is_null($myProductType) && !is_string($myProductType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myProductType, true), gettype($myProductType)), __LINE__);
        }
        $this->myProductType = $myProductType;
        return $this;
    }
    /**
     * Get myInventory value
     * @return \StructType\ItemInfo[]|null
     */
    public function getMyInventory()
    {
        return $this->myInventory;
    }
    /**
     * This method is responsible for validating the values passed to the setMyInventory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMyInventory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMyInventoryForArrayConstraintsFromSetMyInventory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productInfoMyInventoryItem) {
            // validation for constraint: itemType
            if (!$productInfoMyInventoryItem instanceof \StructType\ItemInfo) {
                $invalidValues[] = is_object($productInfoMyInventoryItem) ? get_class($productInfoMyInventoryItem) : sprintf('%s(%s)', gettype($productInfoMyInventoryItem), var_export($productInfoMyInventoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The myInventory property can only contain items of type \StructType\ItemInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set myInventory value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemInfo[] $myInventory
     * @return \StructType\ProductInfo
     */
    public function setMyInventory(array $myInventory = array())
    {
        // validation for constraint: array
        if ('' !== ($myInventoryArrayErrorMessage = self::validateMyInventoryForArrayConstraintsFromSetMyInventory($myInventory))) {
            throw new \InvalidArgumentException($myInventoryArrayErrorMessage, __LINE__);
        }
        $this->myInventory = $myInventory;
        return $this;
    }
    /**
     * Add item to myInventory value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemInfo $item
     * @return \StructType\ProductInfo
     */
    public function addToMyInventory(\StructType\ItemInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemInfo) {
            throw new \InvalidArgumentException(sprintf('The myInventory property can only contain items of type \StructType\ItemInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->myInventory[] = $item;
        return $this;
    }
    /**
     * Get myNumberOfPersonMinMax value
     * @return string|null
     */
    public function getMyNumberOfPersonMinMax()
    {
        return $this->myNumberOfPersonMinMax;
    }
    /**
     * Set myNumberOfPersonMinMax value
     * @param string $myNumberOfPersonMinMax
     * @return \StructType\ProductInfo
     */
    public function setMyNumberOfPersonMinMax($myNumberOfPersonMinMax = null)
    {
        // validation for constraint: string
        if (!is_null($myNumberOfPersonMinMax) && !is_string($myNumberOfPersonMinMax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myNumberOfPersonMinMax, true), gettype($myNumberOfPersonMinMax)), __LINE__);
        }
        $this->myNumberOfPersonMinMax = $myNumberOfPersonMinMax;
        return $this;
    }
    /**
     * Get myFreeText value
     * @return string|null
     */
    public function getMyFreeText()
    {
        return $this->myFreeText;
    }
    /**
     * Set myFreeText value
     * @param string $myFreeText
     * @return \StructType\ProductInfo
     */
    public function setMyFreeText($myFreeText = null)
    {
        // validation for constraint: string
        if (!is_null($myFreeText) && !is_string($myFreeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myFreeText, true), gettype($myFreeText)), __LINE__);
        }
        $this->myFreeText = $myFreeText;
        return $this;
    }
    /**
     * Get myAccommodationType value
     * @return string|null
     */
    public function getMyAccommodationType()
    {
        return $this->myAccommodationType;
    }
    /**
     * Set myAccommodationType value
     * @param string $myAccommodationType
     * @return \StructType\ProductInfo
     */
    public function setMyAccommodationType($myAccommodationType = null)
    {
        // validation for constraint: string
        if (!is_null($myAccommodationType) && !is_string($myAccommodationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myAccommodationType, true), gettype($myAccommodationType)), __LINE__);
        }
        $this->myAccommodationType = $myAccommodationType;
        return $this;
    }
    /**
     * Get myFullName value
     * @return string|null
     */
    public function getMyFullName()
    {
        return $this->myFullName;
    }
    /**
     * Set myFullName value
     * @param string $myFullName
     * @return \StructType\ProductInfo
     */
    public function setMyFullName($myFullName = null)
    {
        // validation for constraint: string
        if (!is_null($myFullName) && !is_string($myFullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myFullName, true), gettype($myFullName)), __LINE__);
        }
        $this->myFullName = $myFullName;
        return $this;
    }
    /**
     * Get myMarketingTags value
     * @return \StructType\MarketingTag[]|null
     */
    public function getMyMarketingTags()
    {
        return $this->myMarketingTags;
    }
    /**
     * This method is responsible for validating the values passed to the setMyMarketingTags method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMyMarketingTags method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMyMarketingTagsForArrayConstraintsFromSetMyMarketingTags(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $productInfoMyMarketingTagsItem) {
            // validation for constraint: itemType
            if (!$productInfoMyMarketingTagsItem instanceof \StructType\MarketingTag) {
                $invalidValues[] = is_object($productInfoMyMarketingTagsItem) ? get_class($productInfoMyMarketingTagsItem) : sprintf('%s(%s)', gettype($productInfoMyMarketingTagsItem), var_export($productInfoMyMarketingTagsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The myMarketingTags property can only contain items of type \StructType\MarketingTag, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set myMarketingTags value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketingTag[] $myMarketingTags
     * @return \StructType\ProductInfo
     */
    public function setMyMarketingTags(array $myMarketingTags = array())
    {
        // validation for constraint: array
        if ('' !== ($myMarketingTagsArrayErrorMessage = self::validateMyMarketingTagsForArrayConstraintsFromSetMyMarketingTags($myMarketingTags))) {
            throw new \InvalidArgumentException($myMarketingTagsArrayErrorMessage, __LINE__);
        }
        $this->myMarketingTags = $myMarketingTags;
        return $this;
    }
    /**
     * Add item to myMarketingTags value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketingTag $item
     * @return \StructType\ProductInfo
     */
    public function addToMyMarketingTags(\StructType\MarketingTag $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MarketingTag) {
            throw new \InvalidArgumentException(sprintf('The myMarketingTags property can only contain items of type \StructType\MarketingTag, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->myMarketingTags[] = $item;
        return $this;
    }
}
