<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstablishmentFilter StructType
 * @subpackage Structs
 */
class EstablishmentFilter extends AbstractStructBase
{
    /**
     * The nbStarsMin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $nbStarsMin;
    /**
     * The nbStarsMax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $nbStarsMax;
    /**
     * The idList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $idList;
    /**
     * The serviceList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfService
     */
    public $serviceList;
    /**
     * The Domains
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Domains;
    /**
     * The clustersList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt
     */
    public $clustersList;
    /**
     * Constructor method for EstablishmentFilter
     * @uses EstablishmentFilter::setNbStarsMin()
     * @uses EstablishmentFilter::setNbStarsMax()
     * @uses EstablishmentFilter::setIdList()
     * @uses EstablishmentFilter::setServiceList()
     * @uses EstablishmentFilter::setDomains()
     * @uses EstablishmentFilter::setClustersList()
     * @param int $nbStarsMin
     * @param int $nbStarsMax
     * @param \ArrayType\ArrayOfInt $idList
     * @param \ArrayType\ArrayOfService $serviceList
     * @param \ArrayType\ArrayOfString $domains
     * @param \ArrayType\ArrayOfInt $clustersList
     */
    public function __construct($nbStarsMin = null, $nbStarsMax = null, \ArrayType\ArrayOfInt $idList = null, \ArrayType\ArrayOfService $serviceList = null, \ArrayType\ArrayOfString $domains = null, \ArrayType\ArrayOfInt $clustersList = null)
    {
        $this
            ->setNbStarsMin($nbStarsMin)
            ->setNbStarsMax($nbStarsMax)
            ->setIdList($idList)
            ->setServiceList($serviceList)
            ->setDomains($domains)
            ->setClustersList($clustersList);
    }
    /**
     * Get nbStarsMin value
     * @return int
     */
    public function getNbStarsMin()
    {
        return $this->nbStarsMin;
    }
    /**
     * Set nbStarsMin value
     * @param int $nbStarsMin
     * @return \StructType\EstablishmentFilter
     */
    public function setNbStarsMin($nbStarsMin = null)
    {
        // validation for constraint: int
        if (!is_null($nbStarsMin) && !(is_int($nbStarsMin) || ctype_digit($nbStarsMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbStarsMin, true), gettype($nbStarsMin)), __LINE__);
        }
        $this->nbStarsMin = $nbStarsMin;
        return $this;
    }
    /**
     * Get nbStarsMax value
     * @return int
     */
    public function getNbStarsMax()
    {
        return $this->nbStarsMax;
    }
    /**
     * Set nbStarsMax value
     * @param int $nbStarsMax
     * @return \StructType\EstablishmentFilter
     */
    public function setNbStarsMax($nbStarsMax = null)
    {
        // validation for constraint: int
        if (!is_null($nbStarsMax) && !(is_int($nbStarsMax) || ctype_digit($nbStarsMax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nbStarsMax, true), gettype($nbStarsMax)), __LINE__);
        }
        $this->nbStarsMax = $nbStarsMax;
        return $this;
    }
    /**
     * Get idList value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getIdList()
    {
        return $this->idList;
    }
    /**
     * Set idList value
     * @param \ArrayType\ArrayOfInt $idList
     * @return \StructType\EstablishmentFilter
     */
    public function setIdList(\ArrayType\ArrayOfInt $idList = null)
    {
        $this->idList = $idList;
        return $this;
    }
    /**
     * Get serviceList value
     * @return \ArrayType\ArrayOfService|null
     */
    public function getServiceList()
    {
        return $this->serviceList;
    }
    /**
     * Set serviceList value
     * @param \ArrayType\ArrayOfService $serviceList
     * @return \StructType\EstablishmentFilter
     */
    public function setServiceList(\ArrayType\ArrayOfService $serviceList = null)
    {
        $this->serviceList = $serviceList;
        return $this;
    }
    /**
     * Get Domains value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getDomains()
    {
        return $this->Domains;
    }
    /**
     * Set Domains value
     * @param \ArrayType\ArrayOfString $domains
     * @return \StructType\EstablishmentFilter
     */
    public function setDomains(\ArrayType\ArrayOfString $domains = null)
    {
        $this->Domains = $domains;
        return $this;
    }
    /**
     * Get clustersList value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getClustersList()
    {
        return $this->clustersList;
    }
    /**
     * Set clustersList value
     * @param \ArrayType\ArrayOfInt $clustersList
     * @return \StructType\EstablishmentFilter
     */
    public function setClustersList(\ArrayType\ArrayOfInt $clustersList = null)
    {
        $this->clustersList = $clustersList;
        return $this;
    }
}
