<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for seasonEnum EnumType
 * @subpackage Enumerations
 */
class SeasonEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'spring'
     * @return string 'spring'
     */
    const VALUE_SPRING = 'spring';
    /**
     * Constant for value 'summer'
     * @return string 'summer'
     */
    const VALUE_SUMMER = 'summer';
    /**
     * Constant for value 'autumn'
     * @return string 'autumn'
     */
    const VALUE_AUTUMN = 'autumn';
    /**
     * Constant for value 'winter'
     * @return string 'winter'
     */
    const VALUE_WINTER = 'winter';
    /**
     * Return allowed values
     * @uses self::VALUE_SPRING
     * @uses self::VALUE_SUMMER
     * @uses self::VALUE_AUTUMN
     * @uses self::VALUE_WINTER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SPRING,
            self::VALUE_SUMMER,
            self::VALUE_AUTUMN,
            self::VALUE_WINTER,
        );
    }
}
