<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IBSSpecificInformations StructType
 * @subpackage Structs
 */
class IBSSpecificInformations extends AbstractStructBase
{
    /**
     * The Score
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Score;
    /**
     * The ScoreTotal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ScoreTotal;
    /**
     * The CommissionRate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CommissionRate;
    /**
     * Constructor method for IBSSpecificInformations
     * @uses IBSSpecificInformations::setScore()
     * @uses IBSSpecificInformations::setScoreTotal()
     * @uses IBSSpecificInformations::setCommissionRate()
     * @param int $score
     * @param int $scoreTotal
     * @param float $commissionRate
     */
    public function __construct($score = null, $scoreTotal = null, $commissionRate = null)
    {
        $this
            ->setScore($score)
            ->setScoreTotal($scoreTotal)
            ->setCommissionRate($commissionRate);
    }
    /**
     * Get Score value
     * @return int
     */
    public function getScore()
    {
        return $this->Score;
    }
    /**
     * Set Score value
     * @param int $score
     * @return \StructType\IBSSpecificInformations
     */
    public function setScore($score = null)
    {
        // validation for constraint: int
        if (!is_null($score) && !(is_int($score) || ctype_digit($score))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($score, true), gettype($score)), __LINE__);
        }
        $this->Score = $score;
        return $this;
    }
    /**
     * Get ScoreTotal value
     * @return int
     */
    public function getScoreTotal()
    {
        return $this->ScoreTotal;
    }
    /**
     * Set ScoreTotal value
     * @param int $scoreTotal
     * @return \StructType\IBSSpecificInformations
     */
    public function setScoreTotal($scoreTotal = null)
    {
        // validation for constraint: int
        if (!is_null($scoreTotal) && !(is_int($scoreTotal) || ctype_digit($scoreTotal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scoreTotal, true), gettype($scoreTotal)), __LINE__);
        }
        $this->ScoreTotal = $scoreTotal;
        return $this;
    }
    /**
     * Get CommissionRate value
     * @return float
     */
    public function getCommissionRate()
    {
        return $this->CommissionRate;
    }
    /**
     * Set CommissionRate value
     * @param float $commissionRate
     * @return \StructType\IBSSpecificInformations
     */
    public function setCommissionRate($commissionRate = null)
    {
        // validation for constraint: float
        if (!is_null($commissionRate) && !(is_float($commissionRate) || is_numeric($commissionRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionRate, true), gettype($commissionRate)), __LINE__);
        }
        $this->CommissionRate = $commissionRate;
        return $this;
    }
}
