<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTypeOfProduct ArrayType
 * @subpackage Arrays
 */
class ArrayOfTypeOfProduct extends AbstractStructArrayBase
{
    /**
     * The TypeOfProduct
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $TypeOfProduct;
    /**
     * Constructor method for ArrayOfTypeOfProduct
     * @uses ArrayOfTypeOfProduct::setTypeOfProduct()
     * @param string[] $typeOfProduct
     */
    public function __construct(array $typeOfProduct = array())
    {
        $this
            ->setTypeOfProduct($typeOfProduct);
    }
    /**
     * Get TypeOfProduct value
     * @return string[]|null
     */
    public function getTypeOfProduct()
    {
        return $this->TypeOfProduct;
    }
    /**
     * This method is responsible for validating the values passed to the setTypeOfProduct method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTypeOfProduct method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeOfProductForArrayConstraintsFromSetTypeOfProduct(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTypeOfProductTypeOfProductItem) {
            // validation for constraint: enumeration
            if (!\EnumType\TypeOfProduct::valueIsValid($arrayOfTypeOfProductTypeOfProductItem)) {
                $invalidValues[] = is_object($arrayOfTypeOfProductTypeOfProductItem) ? get_class($arrayOfTypeOfProductTypeOfProductItem) : sprintf('%s(%s)', gettype($arrayOfTypeOfProductTypeOfProductItem), var_export($arrayOfTypeOfProductTypeOfProductItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeOfProduct', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\TypeOfProduct::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TypeOfProduct value
     * @uses \EnumType\TypeOfProduct::valueIsValid()
     * @uses \EnumType\TypeOfProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $typeOfProduct
     * @return \ArrayType\ArrayOfTypeOfProduct
     */
    public function setTypeOfProduct(array $typeOfProduct = array())
    {
        // validation for constraint: array
        if ('' !== ($typeOfProductArrayErrorMessage = self::validateTypeOfProductForArrayConstraintsFromSetTypeOfProduct($typeOfProduct))) {
            throw new \InvalidArgumentException($typeOfProductArrayErrorMessage, __LINE__);
        }
        $this->TypeOfProduct = $typeOfProduct;
        return $this;
    }
    /**
     * Add item to TypeOfProduct value
     * @uses \EnumType\TypeOfProduct::valueIsValid()
     * @uses \EnumType\TypeOfProduct::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfTypeOfProduct
     */
    public function addToTypeOfProduct($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeOfProduct::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeOfProduct', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\TypeOfProduct::getValidValues())), __LINE__);
        }
        $this->TypeOfProduct[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Add element to array
     * @see AbstractStructArrayBase::add()
     * @throws \InvalidArgumentException
     * @uses \EnumType\TypeOfProduct::valueIsValid()
     * @param string $item
     * @return \ArrayType\ArrayOfTypeOfProduct
     */
    public function add($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeOfProduct::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeOfProduct', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\TypeOfProduct::getValidValues())), __LINE__);
        }
        return parent::add($item);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TypeOfProduct
     */
    public function getAttributeName()
    {
        return 'TypeOfProduct';
    }
}
