<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStars ArrayType
 * @subpackage Arrays
 */
class ArrayOfStars extends AbstractStructArrayBase
{
    /**
     * The Stars
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Stars[]
     */
    public $Stars;
    /**
     * Constructor method for ArrayOfStars
     * @uses ArrayOfStars::setStars()
     * @param \StructType\Stars[] $stars
     */
    public function __construct(array $stars = array())
    {
        $this
            ->setStars($stars);
    }
    /**
     * Get Stars value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Stars[]|null
     */
    public function getStars()
    {
        return isset($this->Stars) ? $this->Stars : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStars method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStars method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStarsForArrayConstraintsFromSetStars(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfStarsStarsItem) {
            // validation for constraint: itemType
            if (!$arrayOfStarsStarsItem instanceof \StructType\Stars) {
                $invalidValues[] = is_object($arrayOfStarsStarsItem) ? get_class($arrayOfStarsStarsItem) : sprintf('%s(%s)', gettype($arrayOfStarsStarsItem), var_export($arrayOfStarsStarsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Stars property can only contain items of type \StructType\Stars, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Stars value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Stars[] $stars
     * @return \ArrayType\ArrayOfStars
     */
    public function setStars(array $stars = array())
    {
        // validation for constraint: array
        if ('' !== ($starsArrayErrorMessage = self::validateStarsForArrayConstraintsFromSetStars($stars))) {
            throw new \InvalidArgumentException($starsArrayErrorMessage, __LINE__);
        }
        if (is_null($stars) || (is_array($stars) && empty($stars))) {
            unset($this->Stars);
        } else {
            $this->Stars = $stars;
        }
        return $this;
    }
    /**
     * Add item to Stars value
     * @throws \InvalidArgumentException
     * @param \StructType\Stars $item
     * @return \ArrayType\ArrayOfStars
     */
    public function addToStars(\StructType\Stars $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Stars) {
            throw new \InvalidArgumentException(sprintf('The Stars property can only contain items of type \StructType\Stars, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Stars[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Stars|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Stars|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Stars|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Stars|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Stars|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Stars
     */
    public function getAttributeName()
    {
        return 'Stars';
    }
}
