<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OptionSelected StructType
 * @subpackage Structs
 */
class OptionSelected extends AbstractStructBase
{
    /**
     * The optionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $optionID;
    /**
     * The optionQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $optionQuantity;
    /**
     * Constructor method for OptionSelected
     * @uses OptionSelected::setOptionID()
     * @uses OptionSelected::setOptionQuantity()
     * @param int $optionID
     * @param int $optionQuantity
     */
    public function __construct($optionID = null, $optionQuantity = null)
    {
        $this
            ->setOptionID($optionID)
            ->setOptionQuantity($optionQuantity);
    }
    /**
     * Get optionID value
     * @return int
     */
    public function getOptionID()
    {
        return $this->optionID;
    }
    /**
     * Set optionID value
     * @param int $optionID
     * @return \StructType\OptionSelected
     */
    public function setOptionID($optionID = null)
    {
        // validation for constraint: int
        if (!is_null($optionID) && !(is_int($optionID) || ctype_digit($optionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($optionID, true), gettype($optionID)), __LINE__);
        }
        $this->optionID = $optionID;
        return $this;
    }
    /**
     * Get optionQuantity value
     * @return int
     */
    public function getOptionQuantity()
    {
        return $this->optionQuantity;
    }
    /**
     * Set optionQuantity value
     * @param int $optionQuantity
     * @return \StructType\OptionSelected
     */
    public function setOptionQuantity($optionQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($optionQuantity) && !(is_int($optionQuantity) || ctype_digit($optionQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($optionQuantity, true), gettype($optionQuantity)), __LINE__);
        }
        $this->optionQuantity = $optionQuantity;
        return $this;
    }
}
