<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productPrice StructType
 * @subpackage Structs
 */
class ProductPrice extends AbstractStructBase
{
    /**
     * The product_pricingID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $product_pricingID;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $price;
    /**
     * The finalPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $finalPrice;
    /**
     * The bookingFees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $bookingFees;
    /**
     * The priceWithMinimalOptions
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $priceWithMinimalOptions;
    /**
     * The priceWithoutExtraOption
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $priceWithoutExtraOption;
    /**
     * The currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $currency;
    /**
     * The product_priceDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product_priceDescription;
    /**
     * The product_pricingDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product_pricingDescription;
    /**
     * The pricingTypeCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pricingTypeCode;
    /**
     * The product_pricingText
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product_pricingText;
    /**
     * The product_pricingPublicName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $product_pricingPublicName;
    /**
     * Constructor method for productPrice
     * @uses ProductPrice::setProduct_pricingID()
     * @uses ProductPrice::setPrice()
     * @uses ProductPrice::setFinalPrice()
     * @uses ProductPrice::setBookingFees()
     * @uses ProductPrice::setPriceWithMinimalOptions()
     * @uses ProductPrice::setPriceWithoutExtraOption()
     * @uses ProductPrice::setCurrency()
     * @uses ProductPrice::setProduct_priceDescription()
     * @uses ProductPrice::setProduct_pricingDescription()
     * @uses ProductPrice::setPricingTypeCode()
     * @uses ProductPrice::setProduct_pricingText()
     * @uses ProductPrice::setProduct_pricingPublicName()
     * @param int $product_pricingID
     * @param float $price
     * @param float $finalPrice
     * @param float $bookingFees
     * @param float $priceWithMinimalOptions
     * @param float $priceWithoutExtraOption
     * @param string $currency
     * @param string $product_priceDescription
     * @param string $product_pricingDescription
     * @param string $pricingTypeCode
     * @param string $product_pricingText
     * @param string $product_pricingPublicName
     */
    public function __construct($product_pricingID = null, $price = null, $finalPrice = null, $bookingFees = null, $priceWithMinimalOptions = null, $priceWithoutExtraOption = null, $currency = null, $product_priceDescription = null, $product_pricingDescription = null, $pricingTypeCode = null, $product_pricingText = null, $product_pricingPublicName = null)
    {
        $this
            ->setProduct_pricingID($product_pricingID)
            ->setPrice($price)
            ->setFinalPrice($finalPrice)
            ->setBookingFees($bookingFees)
            ->setPriceWithMinimalOptions($priceWithMinimalOptions)
            ->setPriceWithoutExtraOption($priceWithoutExtraOption)
            ->setCurrency($currency)
            ->setProduct_priceDescription($product_priceDescription)
            ->setProduct_pricingDescription($product_pricingDescription)
            ->setPricingTypeCode($pricingTypeCode)
            ->setProduct_pricingText($product_pricingText)
            ->setProduct_pricingPublicName($product_pricingPublicName);
    }
    /**
     * Get product_pricingID value
     * @return int
     */
    public function getProduct_pricingID()
    {
        return $this->product_pricingID;
    }
    /**
     * Set product_pricingID value
     * @param int $product_pricingID
     * @return \StructType\ProductPrice
     */
    public function setProduct_pricingID($product_pricingID = null)
    {
        // validation for constraint: int
        if (!is_null($product_pricingID) && !(is_int($product_pricingID) || ctype_digit($product_pricingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($product_pricingID, true), gettype($product_pricingID)), __LINE__);
        }
        $this->product_pricingID = $product_pricingID;
        return $this;
    }
    /**
     * Get price value
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ProductPrice
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get finalPrice value
     * @return float
     */
    public function getFinalPrice()
    {
        return $this->finalPrice;
    }
    /**
     * Set finalPrice value
     * @param float $finalPrice
     * @return \StructType\ProductPrice
     */
    public function setFinalPrice($finalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($finalPrice) && !(is_float($finalPrice) || is_numeric($finalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($finalPrice, true), gettype($finalPrice)), __LINE__);
        }
        $this->finalPrice = $finalPrice;
        return $this;
    }
    /**
     * Get bookingFees value
     * @return float
     */
    public function getBookingFees()
    {
        return $this->bookingFees;
    }
    /**
     * Set bookingFees value
     * @param float $bookingFees
     * @return \StructType\ProductPrice
     */
    public function setBookingFees($bookingFees = null)
    {
        // validation for constraint: float
        if (!is_null($bookingFees) && !(is_float($bookingFees) || is_numeric($bookingFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bookingFees, true), gettype($bookingFees)), __LINE__);
        }
        $this->bookingFees = $bookingFees;
        return $this;
    }
    /**
     * Get priceWithMinimalOptions value
     * @return float
     */
    public function getPriceWithMinimalOptions()
    {
        return $this->priceWithMinimalOptions;
    }
    /**
     * Set priceWithMinimalOptions value
     * @param float $priceWithMinimalOptions
     * @return \StructType\ProductPrice
     */
    public function setPriceWithMinimalOptions($priceWithMinimalOptions = null)
    {
        // validation for constraint: float
        if (!is_null($priceWithMinimalOptions) && !(is_float($priceWithMinimalOptions) || is_numeric($priceWithMinimalOptions))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceWithMinimalOptions, true), gettype($priceWithMinimalOptions)), __LINE__);
        }
        $this->priceWithMinimalOptions = $priceWithMinimalOptions;
        return $this;
    }
    /**
     * Get priceWithoutExtraOption value
     * @return float
     */
    public function getPriceWithoutExtraOption()
    {
        return $this->priceWithoutExtraOption;
    }
    /**
     * Set priceWithoutExtraOption value
     * @param float $priceWithoutExtraOption
     * @return \StructType\ProductPrice
     */
    public function setPriceWithoutExtraOption($priceWithoutExtraOption = null)
    {
        // validation for constraint: float
        if (!is_null($priceWithoutExtraOption) && !(is_float($priceWithoutExtraOption) || is_numeric($priceWithoutExtraOption))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($priceWithoutExtraOption, true), gettype($priceWithoutExtraOption)), __LINE__);
        }
        $this->priceWithoutExtraOption = $priceWithoutExtraOption;
        return $this;
    }
    /**
     * Get currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    /**
     * Set currency value
     * @param string $currency
     * @return \StructType\ProductPrice
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->currency = $currency;
        return $this;
    }
    /**
     * Get product_priceDescription value
     * @return string|null
     */
    public function getProduct_priceDescription()
    {
        return $this->product_priceDescription;
    }
    /**
     * Set product_priceDescription value
     * @param string $product_priceDescription
     * @return \StructType\ProductPrice
     */
    public function setProduct_priceDescription($product_priceDescription = null)
    {
        // validation for constraint: string
        if (!is_null($product_priceDescription) && !is_string($product_priceDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product_priceDescription, true), gettype($product_priceDescription)), __LINE__);
        }
        $this->product_priceDescription = $product_priceDescription;
        return $this;
    }
    /**
     * Get product_pricingDescription value
     * @return string|null
     */
    public function getProduct_pricingDescription()
    {
        return $this->product_pricingDescription;
    }
    /**
     * Set product_pricingDescription value
     * @param string $product_pricingDescription
     * @return \StructType\ProductPrice
     */
    public function setProduct_pricingDescription($product_pricingDescription = null)
    {
        // validation for constraint: string
        if (!is_null($product_pricingDescription) && !is_string($product_pricingDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product_pricingDescription, true), gettype($product_pricingDescription)), __LINE__);
        }
        $this->product_pricingDescription = $product_pricingDescription;
        return $this;
    }
    /**
     * Get pricingTypeCode value
     * @return string|null
     */
    public function getPricingTypeCode()
    {
        return $this->pricingTypeCode;
    }
    /**
     * Set pricingTypeCode value
     * @param string $pricingTypeCode
     * @return \StructType\ProductPrice
     */
    public function setPricingTypeCode($pricingTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($pricingTypeCode) && !is_string($pricingTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricingTypeCode, true), gettype($pricingTypeCode)), __LINE__);
        }
        $this->pricingTypeCode = $pricingTypeCode;
        return $this;
    }
    /**
     * Get product_pricingText value
     * @return string|null
     */
    public function getProduct_pricingText()
    {
        return $this->product_pricingText;
    }
    /**
     * Set product_pricingText value
     * @param string $product_pricingText
     * @return \StructType\ProductPrice
     */
    public function setProduct_pricingText($product_pricingText = null)
    {
        // validation for constraint: string
        if (!is_null($product_pricingText) && !is_string($product_pricingText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product_pricingText, true), gettype($product_pricingText)), __LINE__);
        }
        $this->product_pricingText = $product_pricingText;
        return $this;
    }
    /**
     * Get product_pricingPublicName value
     * @return string|null
     */
    public function getProduct_pricingPublicName()
    {
        return $this->product_pricingPublicName;
    }
    /**
     * Set product_pricingPublicName value
     * @param string $product_pricingPublicName
     * @return \StructType\ProductPrice
     */
    public function setProduct_pricingPublicName($product_pricingPublicName = null)
    {
        // validation for constraint: string
        if (!is_null($product_pricingPublicName) && !is_string($product_pricingPublicName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($product_pricingPublicName, true), gettype($product_pricingPublicName)), __LINE__);
        }
        $this->product_pricingPublicName = $product_pricingPublicName;
        return $this;
    }
}
