<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimeSlotValue StructType
 * @subpackage Structs
 */
class TimeSlotValue extends ItemTypeValue
{
    /**
     * The timeBegin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeBegin;
    /**
     * The timeEnd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $timeEnd;
    /**
     * Constructor method for TimeSlotValue
     * @uses TimeSlotValue::setTimeBegin()
     * @uses TimeSlotValue::setTimeEnd()
     * @param string $timeBegin
     * @param string $timeEnd
     */
    public function __construct($timeBegin = null, $timeEnd = null)
    {
        $this
            ->setTimeBegin($timeBegin)
            ->setTimeEnd($timeEnd);
    }
    /**
     * Get timeBegin value
     * @return string|null
     */
    public function getTimeBegin()
    {
        return $this->timeBegin;
    }
    /**
     * Set timeBegin value
     * @param string $timeBegin
     * @return \StructType\TimeSlotValue
     */
    public function setTimeBegin($timeBegin = null)
    {
        // validation for constraint: string
        if (!is_null($timeBegin) && !is_string($timeBegin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeBegin, true), gettype($timeBegin)), __LINE__);
        }
        $this->timeBegin = $timeBegin;
        return $this;
    }
    /**
     * Get timeEnd value
     * @return string|null
     */
    public function getTimeEnd()
    {
        return $this->timeEnd;
    }
    /**
     * Set timeEnd value
     * @param string $timeEnd
     * @return \StructType\TimeSlotValue
     */
    public function setTimeEnd($timeEnd = null)
    {
        // validation for constraint: string
        if (!is_null($timeEnd) && !is_string($timeEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeEnd, true), gettype($timeEnd)), __LINE__);
        }
        $this->timeEnd = $timeEnd;
        return $this;
    }
}
