<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SpecificCustomerOption StructType
 * @subpackage Structs
 */
class SpecificCustomerOption extends AbstractStructBase
{
    /**
     * The OptionId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $OptionId;
    /**
     * The IsIncludedInBasePrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsIncludedInBasePrice;
    /**
     * The CustomerAge
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CustomerAge;
    /**
     * Constructor method for SpecificCustomerOption
     * @uses SpecificCustomerOption::setOptionId()
     * @uses SpecificCustomerOption::setIsIncludedInBasePrice()
     * @uses SpecificCustomerOption::setCustomerAge()
     * @param int $optionId
     * @param bool $isIncludedInBasePrice
     * @param int $customerAge
     */
    public function __construct($optionId = null, $isIncludedInBasePrice = null, $customerAge = null)
    {
        $this
            ->setOptionId($optionId)
            ->setIsIncludedInBasePrice($isIncludedInBasePrice)
            ->setCustomerAge($customerAge);
    }
    /**
     * Get OptionId value
     * @return int
     */
    public function getOptionId()
    {
        return $this->OptionId;
    }
    /**
     * Set OptionId value
     * @param int $optionId
     * @return \StructType\SpecificCustomerOption
     */
    public function setOptionId($optionId = null)
    {
        // validation for constraint: int
        if (!is_null($optionId) && !(is_int($optionId) || ctype_digit($optionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($optionId, true), gettype($optionId)), __LINE__);
        }
        $this->OptionId = $optionId;
        return $this;
    }
    /**
     * Get IsIncludedInBasePrice value
     * @return bool
     */
    public function getIsIncludedInBasePrice()
    {
        return $this->IsIncludedInBasePrice;
    }
    /**
     * Set IsIncludedInBasePrice value
     * @param bool $isIncludedInBasePrice
     * @return \StructType\SpecificCustomerOption
     */
    public function setIsIncludedInBasePrice($isIncludedInBasePrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncludedInBasePrice) && !is_bool($isIncludedInBasePrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncludedInBasePrice, true), gettype($isIncludedInBasePrice)), __LINE__);
        }
        $this->IsIncludedInBasePrice = $isIncludedInBasePrice;
        return $this;
    }
    /**
     * Get CustomerAge value
     * @return int
     */
    public function getCustomerAge()
    {
        return $this->CustomerAge;
    }
    /**
     * Set CustomerAge value
     * @param int $customerAge
     * @return \StructType\SpecificCustomerOption
     */
    public function setCustomerAge($customerAge = null)
    {
        // validation for constraint: int
        if (!is_null($customerAge) && !(is_int($customerAge) || ctype_digit($customerAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($customerAge, true), gettype($customerAge)), __LINE__);
        }
        $this->CustomerAge = $customerAge;
        return $this;
    }
}
