<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for photoFormat StructType
 * @subpackage Structs
 */
class PhotoFormat extends AbstractStructBase
{
    /**
     * The mySize
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $mySize;
    /**
     * The myUrl
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $myUrl;
    /**
     * Constructor method for photoFormat
     * @uses PhotoFormat::setMySize()
     * @uses PhotoFormat::setMyUrl()
     * @param string $mySize
     * @param string $myUrl
     */
    public function __construct($mySize = null, $myUrl = null)
    {
        $this
            ->setMySize($mySize)
            ->setMyUrl($myUrl);
    }
    /**
     * Get mySize value
     * @return string
     */
    public function getMySize()
    {
        return $this->mySize;
    }
    /**
     * Set mySize value
     * @uses \EnumType\SizeEnum::valueIsValid()
     * @uses \EnumType\SizeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mySize
     * @return \StructType\PhotoFormat
     */
    public function setMySize($mySize = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SizeEnum::valueIsValid($mySize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SizeEnum', is_array($mySize) ? implode(', ', $mySize) : var_export($mySize, true), implode(', ', \EnumType\SizeEnum::getValidValues())), __LINE__);
        }
        $this->mySize = $mySize;
        return $this;
    }
    /**
     * Get myUrl value
     * @return string|null
     */
    public function getMyUrl()
    {
        return $this->myUrl;
    }
    /**
     * Set myUrl value
     * @param string $myUrl
     * @return \StructType\PhotoFormat
     */
    public function setMyUrl($myUrl = null)
    {
        // validation for constraint: string
        if (!is_null($myUrl) && !is_string($myUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($myUrl, true), gettype($myUrl)), __LINE__);
        }
        $this->myUrl = $myUrl;
        return $this;
    }
}
