<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DateFilter StructType
 * @subpackage Structs
 */
class DateFilter extends AbstractStructBase
{
    /**
     * The startDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $startDate;
    /**
     * The endDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $endDate;
    /**
     * The onlyExactDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $onlyExactDate;
    /**
     * The maxExpirationDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $maxExpirationDate;
    /**
     * The maxDayVariationOnStartDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $maxDayVariationOnStartDate;
    /**
     * The alwaysSearchForAlternative
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $alwaysSearchForAlternative;
    /**
     * The searchComparisonStay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $searchComparisonStay;
    /**
     * The Periods
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfBasicPeriod
     */
    public $Periods;
    /**
     * Constructor method for DateFilter
     * @uses DateFilter::setStartDate()
     * @uses DateFilter::setEndDate()
     * @uses DateFilter::setOnlyExactDate()
     * @uses DateFilter::setMaxExpirationDate()
     * @uses DateFilter::setMaxDayVariationOnStartDate()
     * @uses DateFilter::setAlwaysSearchForAlternative()
     * @uses DateFilter::setSearchComparisonStay()
     * @uses DateFilter::setPeriods()
     * @param string $startDate
     * @param string $endDate
     * @param bool $onlyExactDate
     * @param string $maxExpirationDate
     * @param int $maxDayVariationOnStartDate
     * @param bool $alwaysSearchForAlternative
     * @param bool $searchComparisonStay
     * @param \ArrayType\ArrayOfBasicPeriod $periods
     */
    public function __construct($startDate = null, $endDate = null, $onlyExactDate = null, $maxExpirationDate = null, $maxDayVariationOnStartDate = null, $alwaysSearchForAlternative = null, $searchComparisonStay = null, \ArrayType\ArrayOfBasicPeriod $periods = null)
    {
        $this
            ->setStartDate($startDate)
            ->setEndDate($endDate)
            ->setOnlyExactDate($onlyExactDate)
            ->setMaxExpirationDate($maxExpirationDate)
            ->setMaxDayVariationOnStartDate($maxDayVariationOnStartDate)
            ->setAlwaysSearchForAlternative($alwaysSearchForAlternative)
            ->setSearchComparisonStay($searchComparisonStay)
            ->setPeriods($periods);
    }
    /**
     * Get startDate value
     * @return string
     */
    public function getStartDate()
    {
        return $this->startDate;
    }
    /**
     * Set startDate value
     * @param string $startDate
     * @return \StructType\DateFilter
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->startDate = $startDate;
        return $this;
    }
    /**
     * Get endDate value
     * @return string
     */
    public function getEndDate()
    {
        return $this->endDate;
    }
    /**
     * Set endDate value
     * @param string $endDate
     * @return \StructType\DateFilter
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->endDate = $endDate;
        return $this;
    }
    /**
     * Get onlyExactDate value
     * @return bool
     */
    public function getOnlyExactDate()
    {
        return $this->onlyExactDate;
    }
    /**
     * Set onlyExactDate value
     * @param bool $onlyExactDate
     * @return \StructType\DateFilter
     */
    public function setOnlyExactDate($onlyExactDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyExactDate) && !is_bool($onlyExactDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyExactDate, true), gettype($onlyExactDate)), __LINE__);
        }
        $this->onlyExactDate = $onlyExactDate;
        return $this;
    }
    /**
     * Get maxExpirationDate value
     * @return string
     */
    public function getMaxExpirationDate()
    {
        return $this->maxExpirationDate;
    }
    /**
     * Set maxExpirationDate value
     * @param string $maxExpirationDate
     * @return \StructType\DateFilter
     */
    public function setMaxExpirationDate($maxExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($maxExpirationDate) && !is_string($maxExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxExpirationDate, true), gettype($maxExpirationDate)), __LINE__);
        }
        $this->maxExpirationDate = $maxExpirationDate;
        return $this;
    }
    /**
     * Get maxDayVariationOnStartDate value
     * @return int
     */
    public function getMaxDayVariationOnStartDate()
    {
        return $this->maxDayVariationOnStartDate;
    }
    /**
     * Set maxDayVariationOnStartDate value
     * @param int $maxDayVariationOnStartDate
     * @return \StructType\DateFilter
     */
    public function setMaxDayVariationOnStartDate($maxDayVariationOnStartDate = null)
    {
        // validation for constraint: int
        if (!is_null($maxDayVariationOnStartDate) && !(is_int($maxDayVariationOnStartDate) || ctype_digit($maxDayVariationOnStartDate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxDayVariationOnStartDate, true), gettype($maxDayVariationOnStartDate)), __LINE__);
        }
        $this->maxDayVariationOnStartDate = $maxDayVariationOnStartDate;
        return $this;
    }
    /**
     * Get alwaysSearchForAlternative value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAlwaysSearchForAlternative()
    {
        return isset($this->alwaysSearchForAlternative) ? $this->alwaysSearchForAlternative : null;
    }
    /**
     * Set alwaysSearchForAlternative value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $alwaysSearchForAlternative
     * @return \StructType\DateFilter
     */
    public function setAlwaysSearchForAlternative($alwaysSearchForAlternative = null)
    {
        // validation for constraint: boolean
        if (!is_null($alwaysSearchForAlternative) && !is_bool($alwaysSearchForAlternative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alwaysSearchForAlternative, true), gettype($alwaysSearchForAlternative)), __LINE__);
        }
        if (is_null($alwaysSearchForAlternative) || (is_array($alwaysSearchForAlternative) && empty($alwaysSearchForAlternative))) {
            unset($this->alwaysSearchForAlternative);
        } else {
            $this->alwaysSearchForAlternative = $alwaysSearchForAlternative;
        }
        return $this;
    }
    /**
     * Get searchComparisonStay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSearchComparisonStay()
    {
        return isset($this->searchComparisonStay) ? $this->searchComparisonStay : null;
    }
    /**
     * Set searchComparisonStay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $searchComparisonStay
     * @return \StructType\DateFilter
     */
    public function setSearchComparisonStay($searchComparisonStay = null)
    {
        // validation for constraint: boolean
        if (!is_null($searchComparisonStay) && !is_bool($searchComparisonStay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($searchComparisonStay, true), gettype($searchComparisonStay)), __LINE__);
        }
        if (is_null($searchComparisonStay) || (is_array($searchComparisonStay) && empty($searchComparisonStay))) {
            unset($this->searchComparisonStay);
        } else {
            $this->searchComparisonStay = $searchComparisonStay;
        }
        return $this;
    }
    /**
     * Get Periods value
     * @return \ArrayType\ArrayOfBasicPeriod|null
     */
    public function getPeriods()
    {
        return $this->Periods;
    }
    /**
     * Set Periods value
     * @param \ArrayType\ArrayOfBasicPeriod $periods
     * @return \StructType\DateFilter
     */
    public function setPeriods(\ArrayType\ArrayOfBasicPeriod $periods = null)
    {
        $this->Periods = $periods;
        return $this;
    }
}
