<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for conditions StructType
 * @subpackage Structs
 */
class Conditions extends AbstractStructBase
{
    /**
     * The minimumPeriodForStay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $minimumPeriodForStay;
    /**
     * The arrivalDay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDay
     */
    public $arrivalDay;
    /**
     * The departureDay
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDay
     */
    public $departureDay;
    /**
     * Constructor method for conditions
     * @uses Conditions::setMinimumPeriodForStay()
     * @uses Conditions::setArrivalDay()
     * @uses Conditions::setDepartureDay()
     * @param string $minimumPeriodForStay
     * @param \ArrayType\ArrayOfDay $arrivalDay
     * @param \ArrayType\ArrayOfDay $departureDay
     */
    public function __construct($minimumPeriodForStay = null, \ArrayType\ArrayOfDay $arrivalDay = null, \ArrayType\ArrayOfDay $departureDay = null)
    {
        $this
            ->setMinimumPeriodForStay($minimumPeriodForStay)
            ->setArrivalDay($arrivalDay)
            ->setDepartureDay($departureDay);
    }
    /**
     * Get minimumPeriodForStay value
     * @return string|null
     */
    public function getMinimumPeriodForStay()
    {
        return $this->minimumPeriodForStay;
    }
    /**
     * Set minimumPeriodForStay value
     * @param string $minimumPeriodForStay
     * @return \StructType\Conditions
     */
    public function setMinimumPeriodForStay($minimumPeriodForStay = null)
    {
        // validation for constraint: string
        if (!is_null($minimumPeriodForStay) && !is_string($minimumPeriodForStay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minimumPeriodForStay, true), gettype($minimumPeriodForStay)), __LINE__);
        }
        $this->minimumPeriodForStay = $minimumPeriodForStay;
        return $this;
    }
    /**
     * Get arrivalDay value
     * @return \ArrayType\ArrayOfDay|null
     */
    public function getArrivalDay()
    {
        return $this->arrivalDay;
    }
    /**
     * Set arrivalDay value
     * @param \ArrayType\ArrayOfDay $arrivalDay
     * @return \StructType\Conditions
     */
    public function setArrivalDay(\ArrayType\ArrayOfDay $arrivalDay = null)
    {
        $this->arrivalDay = $arrivalDay;
        return $this;
    }
    /**
     * Get departureDay value
     * @return \ArrayType\ArrayOfDay|null
     */
    public function getDepartureDay()
    {
        return $this->departureDay;
    }
    /**
     * Set departureDay value
     * @param \ArrayType\ArrayOfDay $departureDay
     * @return \StructType\Conditions
     */
    public function setDepartureDay(\ArrayType\ArrayOfDay $departureDay = null)
    {
        $this->departureDay = $departureDay;
        return $this;
    }
}
