<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTerritorial ArrayType
 * @subpackage Arrays
 */
class ArrayOfTerritorial extends AbstractStructArrayBase
{
    /**
     * The Territorial
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Territorial[]
     */
    public $Territorial;
    /**
     * Constructor method for ArrayOfTerritorial
     * @uses ArrayOfTerritorial::setTerritorial()
     * @param \StructType\Territorial[] $territorial
     */
    public function __construct(array $territorial = array())
    {
        $this
            ->setTerritorial($territorial);
    }
    /**
     * Get Territorial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Territorial[]|null
     */
    public function getTerritorial()
    {
        return isset($this->Territorial) ? $this->Territorial : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTerritorial method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTerritorial method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTerritorialForArrayConstraintsFromSetTerritorial(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTerritorialTerritorialItem) {
            // validation for constraint: itemType
            if (!$arrayOfTerritorialTerritorialItem instanceof \StructType\Territorial) {
                $invalidValues[] = is_object($arrayOfTerritorialTerritorialItem) ? get_class($arrayOfTerritorialTerritorialItem) : sprintf('%s(%s)', gettype($arrayOfTerritorialTerritorialItem), var_export($arrayOfTerritorialTerritorialItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Territorial property can only contain items of type \StructType\Territorial, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Territorial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Territorial[] $territorial
     * @return \ArrayType\ArrayOfTerritorial
     */
    public function setTerritorial(array $territorial = array())
    {
        // validation for constraint: array
        if ('' !== ($territorialArrayErrorMessage = self::validateTerritorialForArrayConstraintsFromSetTerritorial($territorial))) {
            throw new \InvalidArgumentException($territorialArrayErrorMessage, __LINE__);
        }
        if (is_null($territorial) || (is_array($territorial) && empty($territorial))) {
            unset($this->Territorial);
        } else {
            $this->Territorial = $territorial;
        }
        return $this;
    }
    /**
     * Add item to Territorial value
     * @throws \InvalidArgumentException
     * @param \StructType\Territorial $item
     * @return \ArrayType\ArrayOfTerritorial
     */
    public function addToTerritorial(\StructType\Territorial $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Territorial) {
            throw new \InvalidArgumentException(sprintf('The Territorial property can only contain items of type \StructType\Territorial, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Territorial[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Territorial|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Territorial|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Territorial|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Territorial|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Territorial|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Territorial
     */
    public function getAttributeName()
    {
        return 'Territorial';
    }
}
