<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Catalogue StructType
 * @subpackage Structs
 */
class Catalogue extends AbstractStructBase
{
    /**
     * The Language
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Language;
    /**
     * The Informations
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEstablishment
     */
    public $Informations;
    /**
     * Constructor method for Catalogue
     * @uses Catalogue::setLanguage()
     * @uses Catalogue::setInformations()
     * @param string $language
     * @param \ArrayType\ArrayOfEstablishment $informations
     */
    public function __construct($language = null, \ArrayType\ArrayOfEstablishment $informations = null)
    {
        $this
            ->setLanguage($language)
            ->setInformations($informations);
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\Catalogue
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Informations value
     * @return \ArrayType\ArrayOfEstablishment|null
     */
    public function getInformations()
    {
        return $this->Informations;
    }
    /**
     * Set Informations value
     * @param \ArrayType\ArrayOfEstablishment $informations
     * @return \StructType\Catalogue
     */
    public function setInformations(\ArrayType\ArrayOfEstablishment $informations = null)
    {
        $this->Informations = $informations;
        return $this;
    }
}
