<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for productPricing StructType
 * @subpackage Structs
 */
class ProductPricing extends AbstractStructBase
{
    /**
     * The pricingID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pricingID;
    /**
     * The arePeriodsOptionIntegrable
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $arePeriodsOptionIntegrable;
    /**
     * The startDayPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $startDayPeriod;
    /**
     * The BookingFees
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BookingFees;
    /**
     * The Label
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Label;
    /**
     * The nbPersMin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nbPersMin;
    /**
     * The nbPersMax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nbPersMax;
    /**
     * The nbPersIncluded
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nbPersIncluded;
    /**
     * The periods
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfProductPeriod
     */
    public $periods;
    /**
     * The options
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfOption
     */
    public $options;
    /**
     * The pricingType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pricingType;
    /**
     * Constructor method for productPricing
     * @uses ProductPricing::setPricingID()
     * @uses ProductPricing::setArePeriodsOptionIntegrable()
     * @uses ProductPricing::setStartDayPeriod()
     * @uses ProductPricing::setBookingFees()
     * @uses ProductPricing::setLabel()
     * @uses ProductPricing::setNbPersMin()
     * @uses ProductPricing::setNbPersMax()
     * @uses ProductPricing::setNbPersIncluded()
     * @uses ProductPricing::setPeriods()
     * @uses ProductPricing::setOptions()
     * @uses ProductPricing::setPricingType()
     * @param int $pricingID
     * @param bool $arePeriodsOptionIntegrable
     * @param string $startDayPeriod
     * @param float $bookingFees
     * @param string $label
     * @param string $nbPersMin
     * @param string $nbPersMax
     * @param string $nbPersIncluded
     * @param \ArrayType\ArrayOfProductPeriod $periods
     * @param \ArrayType\ArrayOfOption $options
     * @param string $pricingType
     */
    public function __construct($pricingID = null, $arePeriodsOptionIntegrable = null, $startDayPeriod = null, $bookingFees = null, $label = null, $nbPersMin = null, $nbPersMax = null, $nbPersIncluded = null, \ArrayType\ArrayOfProductPeriod $periods = null, \ArrayType\ArrayOfOption $options = null, $pricingType = null)
    {
        $this
            ->setPricingID($pricingID)
            ->setArePeriodsOptionIntegrable($arePeriodsOptionIntegrable)
            ->setStartDayPeriod($startDayPeriod)
            ->setBookingFees($bookingFees)
            ->setLabel($label)
            ->setNbPersMin($nbPersMin)
            ->setNbPersMax($nbPersMax)
            ->setNbPersIncluded($nbPersIncluded)
            ->setPeriods($periods)
            ->setOptions($options)
            ->setPricingType($pricingType);
    }
    /**
     * Get pricingID value
     * @return int
     */
    public function getPricingID()
    {
        return $this->pricingID;
    }
    /**
     * Set pricingID value
     * @param int $pricingID
     * @return \StructType\ProductPricing
     */
    public function setPricingID($pricingID = null)
    {
        // validation for constraint: int
        if (!is_null($pricingID) && !(is_int($pricingID) || ctype_digit($pricingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingID, true), gettype($pricingID)), __LINE__);
        }
        $this->pricingID = $pricingID;
        return $this;
    }
    /**
     * Get arePeriodsOptionIntegrable value
     * @return bool
     */
    public function getArePeriodsOptionIntegrable()
    {
        return $this->arePeriodsOptionIntegrable;
    }
    /**
     * Set arePeriodsOptionIntegrable value
     * @param bool $arePeriodsOptionIntegrable
     * @return \StructType\ProductPricing
     */
    public function setArePeriodsOptionIntegrable($arePeriodsOptionIntegrable = null)
    {
        // validation for constraint: boolean
        if (!is_null($arePeriodsOptionIntegrable) && !is_bool($arePeriodsOptionIntegrable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($arePeriodsOptionIntegrable, true), gettype($arePeriodsOptionIntegrable)), __LINE__);
        }
        $this->arePeriodsOptionIntegrable = $arePeriodsOptionIntegrable;
        return $this;
    }
    /**
     * Get startDayPeriod value
     * @return string
     */
    public function getStartDayPeriod()
    {
        return $this->startDayPeriod;
    }
    /**
     * Set startDayPeriod value
     * @uses \EnumType\ProductStartDayPeriod::valueIsValid()
     * @uses \EnumType\ProductStartDayPeriod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startDayPeriod
     * @return \StructType\ProductPricing
     */
    public function setStartDayPeriod($startDayPeriod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductStartDayPeriod::valueIsValid($startDayPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ProductStartDayPeriod', is_array($startDayPeriod) ? implode(', ', $startDayPeriod) : var_export($startDayPeriod, true), implode(', ', \EnumType\ProductStartDayPeriod::getValidValues())), __LINE__);
        }
        $this->startDayPeriod = $startDayPeriod;
        return $this;
    }
    /**
     * Get BookingFees value
     * @return float
     */
    public function getBookingFees()
    {
        return $this->BookingFees;
    }
    /**
     * Set BookingFees value
     * @param float $bookingFees
     * @return \StructType\ProductPricing
     */
    public function setBookingFees($bookingFees = null)
    {
        // validation for constraint: float
        if (!is_null($bookingFees) && !(is_float($bookingFees) || is_numeric($bookingFees))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bookingFees, true), gettype($bookingFees)), __LINE__);
        }
        $this->BookingFees = $bookingFees;
        return $this;
    }
    /**
     * Get Label value
     * @return string|null
     */
    public function getLabel()
    {
        return $this->Label;
    }
    /**
     * Set Label value
     * @param string $label
     * @return \StructType\ProductPricing
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        $this->Label = $label;
        return $this;
    }
    /**
     * Get nbPersMin value
     * @return string|null
     */
    public function getNbPersMin()
    {
        return $this->nbPersMin;
    }
    /**
     * Set nbPersMin value
     * @param string $nbPersMin
     * @return \StructType\ProductPricing
     */
    public function setNbPersMin($nbPersMin = null)
    {
        // validation for constraint: string
        if (!is_null($nbPersMin) && !is_string($nbPersMin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nbPersMin, true), gettype($nbPersMin)), __LINE__);
        }
        $this->nbPersMin = $nbPersMin;
        return $this;
    }
    /**
     * Get nbPersMax value
     * @return string|null
     */
    public function getNbPersMax()
    {
        return $this->nbPersMax;
    }
    /**
     * Set nbPersMax value
     * @param string $nbPersMax
     * @return \StructType\ProductPricing
     */
    public function setNbPersMax($nbPersMax = null)
    {
        // validation for constraint: string
        if (!is_null($nbPersMax) && !is_string($nbPersMax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nbPersMax, true), gettype($nbPersMax)), __LINE__);
        }
        $this->nbPersMax = $nbPersMax;
        return $this;
    }
    /**
     * Get nbPersIncluded value
     * @return string|null
     */
    public function getNbPersIncluded()
    {
        return $this->nbPersIncluded;
    }
    /**
     * Set nbPersIncluded value
     * @param string $nbPersIncluded
     * @return \StructType\ProductPricing
     */
    public function setNbPersIncluded($nbPersIncluded = null)
    {
        // validation for constraint: string
        if (!is_null($nbPersIncluded) && !is_string($nbPersIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nbPersIncluded, true), gettype($nbPersIncluded)), __LINE__);
        }
        $this->nbPersIncluded = $nbPersIncluded;
        return $this;
    }
    /**
     * Get periods value
     * @return \ArrayType\ArrayOfProductPeriod|null
     */
    public function getPeriods()
    {
        return $this->periods;
    }
    /**
     * Set periods value
     * @param \ArrayType\ArrayOfProductPeriod $periods
     * @return \StructType\ProductPricing
     */
    public function setPeriods(\ArrayType\ArrayOfProductPeriod $periods = null)
    {
        $this->periods = $periods;
        return $this;
    }
    /**
     * Get options value
     * @return \ArrayType\ArrayOfOption|null
     */
    public function getOptions()
    {
        return $this->options;
    }
    /**
     * Set options value
     * @param \ArrayType\ArrayOfOption $options
     * @return \StructType\ProductPricing
     */
    public function setOptions(\ArrayType\ArrayOfOption $options = null)
    {
        $this->options = $options;
        return $this;
    }
    /**
     * Get pricingType value
     * @return string|null
     */
    public function getPricingType()
    {
        return $this->pricingType;
    }
    /**
     * Set pricingType value
     * @param string $pricingType
     * @return \StructType\ProductPricing
     */
    public function setPricingType($pricingType = null)
    {
        // validation for constraint: string
        if (!is_null($pricingType) && !is_string($pricingType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricingType, true), gettype($pricingType)), __LINE__);
        }
        $this->pricingType = $pricingType;
        return $this;
    }
}
