<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AvailabilityPeriod StructType
 * @subpackage Structs
 */
class AvailabilityPeriod extends AbstractStructBase
{
    /**
     * The BeginningDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $BeginningDate;
    /**
     * The EndingDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EndingDate;
    /**
     * Constructor method for AvailabilityPeriod
     * @uses AvailabilityPeriod::setBeginningDate()
     * @uses AvailabilityPeriod::setEndingDate()
     * @param string $beginningDate
     * @param string $endingDate
     */
    public function __construct($beginningDate = null, $endingDate = null)
    {
        $this
            ->setBeginningDate($beginningDate)
            ->setEndingDate($endingDate);
    }
    /**
     * Get BeginningDate value
     * @return string
     */
    public function getBeginningDate()
    {
        return $this->BeginningDate;
    }
    /**
     * Set BeginningDate value
     * @param string $beginningDate
     * @return \StructType\AvailabilityPeriod
     */
    public function setBeginningDate($beginningDate = null)
    {
        // validation for constraint: string
        if (!is_null($beginningDate) && !is_string($beginningDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beginningDate, true), gettype($beginningDate)), __LINE__);
        }
        $this->BeginningDate = $beginningDate;
        return $this;
    }
    /**
     * Get EndingDate value
     * @return string
     */
    public function getEndingDate()
    {
        return $this->EndingDate;
    }
    /**
     * Set EndingDate value
     * @param string $endingDate
     * @return \StructType\AvailabilityPeriod
     */
    public function setEndingDate($endingDate = null)
    {
        // validation for constraint: string
        if (!is_null($endingDate) && !is_string($endingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endingDate, true), gettype($endingDate)), __LINE__);
        }
        $this->EndingDate = $endingDate;
        return $this;
    }
}
