<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Test ServiceType
 * @subpackage Services
 */
class Test extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Test
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Test $parameters
     * @return \StructType\TestResponse|bool
     */
    public function Test(\StructType\Test $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Test($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
