<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ricevuta ServiceType
 * @subpackage Services
 */
class Ricevuta extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Ricevuta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Ricevuta $parameters
     * @return \StructType\RicevutaResponse|bool
     */
    public function Ricevuta(\StructType\Ricevuta $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Ricevuta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RicevutaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
