<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ricevuta StructType
 * @subpackage Structs
 */
class Ricevuta extends AbstractStructBase
{
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Data;
    /**
     * The Utente
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Utente;
    /**
     * The token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $token;
    /**
     * The PDF
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PDF;
    /**
     * Constructor method for Ricevuta
     * @uses Ricevuta::setData()
     * @uses Ricevuta::setUtente()
     * @uses Ricevuta::setToken()
     * @uses Ricevuta::setPDF()
     * @param string $data
     * @param string $utente
     * @param string $token
     * @param string $pDF
     */
    public function __construct($data = null, $utente = null, $token = null, $pDF = null)
    {
        $this
            ->setData($data)
            ->setUtente($utente)
            ->setToken($token)
            ->setPDF($pDF);
    }
    /**
     * Get Data value
     * @return string
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param string $data
     * @return \StructType\Ricevuta
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->Data = $data;
        return $this;
    }
    /**
     * Get Utente value
     * @return string|null
     */
    public function getUtente()
    {
        return $this->Utente;
    }
    /**
     * Set Utente value
     * @param string $utente
     * @return \StructType\Ricevuta
     */
    public function setUtente($utente = null)
    {
        // validation for constraint: string
        if (!is_null($utente) && !is_string($utente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($utente, true), gettype($utente)), __LINE__);
        }
        $this->Utente = $utente;
        return $this;
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \StructType\Ricevuta
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
    /**
     * Get PDF value
     * @return string|null
     */
    public function getPDF()
    {
        return $this->PDF;
    }
    /**
     * Set PDF value
     * @param string $pDF
     * @return \StructType\Ricevuta
     */
    public function setPDF($pDF = null)
    {
        // validation for constraint: string
        if (!is_null($pDF) && !is_string($pDF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pDF, true), gettype($pDF)), __LINE__);
        }
        $this->PDF = $pDF;
        return $this;
    }
}
