<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenerateToken StructType
 * @subpackage Structs
 */
class GenerateToken extends AbstractStructBase
{
    /**
     * The Utente
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Utente;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The WsKey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $WsKey;
    /**
     * The result
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EsitoOperazioneServizio
     */
    public $result;
    /**
     * Constructor method for GenerateToken
     * @uses GenerateToken::setUtente()
     * @uses GenerateToken::setPassword()
     * @uses GenerateToken::setWsKey()
     * @uses GenerateToken::setResult()
     * @param string $utente
     * @param string $password
     * @param string $wsKey
     * @param \StructType\EsitoOperazioneServizio $result
     */
    public function __construct($utente = null, $password = null, $wsKey = null, \StructType\EsitoOperazioneServizio $result = null)
    {
        $this
            ->setUtente($utente)
            ->setPassword($password)
            ->setWsKey($wsKey)
            ->setResult($result);
    }
    /**
     * Get Utente value
     * @return string|null
     */
    public function getUtente()
    {
        return $this->Utente;
    }
    /**
     * Set Utente value
     * @param string $utente
     * @return \StructType\GenerateToken
     */
    public function setUtente($utente = null)
    {
        // validation for constraint: string
        if (!is_null($utente) && !is_string($utente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($utente, true), gettype($utente)), __LINE__);
        }
        $this->Utente = $utente;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\GenerateToken
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get WsKey value
     * @return string|null
     */
    public function getWsKey()
    {
        return $this->WsKey;
    }
    /**
     * Set WsKey value
     * @param string $wsKey
     * @return \StructType\GenerateToken
     */
    public function setWsKey($wsKey = null)
    {
        // validation for constraint: string
        if (!is_null($wsKey) && !is_string($wsKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wsKey, true), gettype($wsKey)), __LINE__);
        }
        $this->WsKey = $wsKey;
        return $this;
    }
    /**
     * Get result value
     * @return \StructType\EsitoOperazioneServizio|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param \StructType\EsitoOperazioneServizio $result
     * @return \StructType\GenerateToken
     */
    public function setResult(\StructType\EsitoOperazioneServizio $result = null)
    {
        $this->result = $result;
        return $this;
    }
}
