<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://alloggiatiweb.poliziadistato.it/service/service.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://alloggiatiweb.poliziadistato.it/service/service.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Generate ServiceType
 */
$generate = new \ServiceType\Generate($options);
/**
 * Sample call for GenerateToken operation/method
 */
if ($generate->GenerateToken(new \StructType\GenerateToken()) !== false) {
    print_r($generate->getResult());
} else {
    print_r($generate->getLastError());
}
/**
 * Samples for Authentication ServiceType
 */
$authentication = new \ServiceType\Authentication($options);
/**
 * Sample call for Authentication_Test operation/method
 */
if ($authentication->Authentication_Test(new \StructType\Authentication_Test()) !== false) {
    print_r($authentication->getResult());
} else {
    print_r($authentication->getLastError());
}
/**
 * Samples for Test ServiceType
 */
$test = new \ServiceType\Test($options);
/**
 * Sample call for Test operation/method
 */
if ($test->Test(new \StructType\Test()) !== false) {
    print_r($test->getResult());
} else {
    print_r($test->getLastError());
}
/**
 * Samples for Gestione ServiceType
 */
$gestione = new \ServiceType\Gestione($options);
/**
 * Sample call for GestioneAppartamenti_Test operation/method
 */
if ($gestione->GestioneAppartamenti_Test(new \StructType\GestioneAppartamenti_Test()) !== false) {
    print_r($gestione->getResult());
} else {
    print_r($gestione->getLastError());
}
/**
 * Sample call for GestioneAppartamenti_FileUnico_Test operation/method
 */
if ($gestione->GestioneAppartamenti_FileUnico_Test(new \StructType\GestioneAppartamenti_FileUnico_Test()) !== false) {
    print_r($gestione->getResult());
} else {
    print_r($gestione->getLastError());
}
/**
 * Sample call for GestioneAppartamenti_Send operation/method
 */
if ($gestione->GestioneAppartamenti_Send(new \StructType\GestioneAppartamenti_Send()) !== false) {
    print_r($gestione->getResult());
} else {
    print_r($gestione->getLastError());
}
/**
 * Sample call for GestioneAppartamenti_FileUnico_Send operation/method
 */
if ($gestione->GestioneAppartamenti_FileUnico_Send(new \StructType\GestioneAppartamenti_FileUnico_Send()) !== false) {
    print_r($gestione->getResult());
} else {
    print_r($gestione->getLastError());
}
/**
 * Sample call for GestioneAppartamenti_AggiungiAppartamento operation/method
 */
if ($gestione->GestioneAppartamenti_AggiungiAppartamento(new \StructType\GestioneAppartamenti_AggiungiAppartamento()) !== false) {
    print_r($gestione->getResult());
} else {
    print_r($gestione->getLastError());
}
/**
 * Sample call for GestioneAppartamenti_DisabilitaAppartamento operation/method
 */
if ($gestione->GestioneAppartamenti_DisabilitaAppartamento(new \StructType\GestioneAppartamenti_DisabilitaAppartamento()) !== false) {
    print_r($gestione->getResult());
} else {
    print_r($gestione->getLastError());
}
/**
 * Samples for Send ServiceType
 */
$send = new \ServiceType\Send($options);
/**
 * Sample call for Send operation/method
 */
if ($send->Send(new \StructType\Send()) !== false) {
    print_r($send->getResult());
} else {
    print_r($send->getLastError());
}
/**
 * Samples for Tabella ServiceType
 */
$tabella = new \ServiceType\Tabella($options);
/**
 * Sample call for Tabella operation/method
 */
if ($tabella->Tabella(new \StructType\Tabella()) !== false) {
    print_r($tabella->getResult());
} else {
    print_r($tabella->getLastError());
}
/**
 * Samples for Ricevuta ServiceType
 */
$ricevuta = new \ServiceType\Ricevuta($options);
/**
 * Sample call for Ricevuta operation/method
 */
if ($ricevuta->Ricevuta(new \StructType\Ricevuta()) !== false) {
    print_r($ricevuta->getResult());
} else {
    print_r($ricevuta->getLastError());
}
