<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TokenInfo StructType
 * @subpackage Structs
 */
class TokenInfo extends AbstractStructBase
{
    /**
     * The issued
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $issued;
    /**
     * The expires
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $expires;
    /**
     * The token
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $token;
    /**
     * Constructor method for TokenInfo
     * @uses TokenInfo::setIssued()
     * @uses TokenInfo::setExpires()
     * @uses TokenInfo::setToken()
     * @param string $issued
     * @param string $expires
     * @param string $token
     */
    public function __construct($issued = null, $expires = null, $token = null)
    {
        $this
            ->setIssued($issued)
            ->setExpires($expires)
            ->setToken($token);
    }
    /**
     * Get issued value
     * @return string
     */
    public function getIssued()
    {
        return $this->issued;
    }
    /**
     * Set issued value
     * @param string $issued
     * @return \StructType\TokenInfo
     */
    public function setIssued($issued = null)
    {
        // validation for constraint: string
        if (!is_null($issued) && !is_string($issued)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issued, true), gettype($issued)), __LINE__);
        }
        $this->issued = $issued;
        return $this;
    }
    /**
     * Get expires value
     * @return string
     */
    public function getExpires()
    {
        return $this->expires;
    }
    /**
     * Set expires value
     * @param string $expires
     * @return \StructType\TokenInfo
     */
    public function setExpires($expires = null)
    {
        // validation for constraint: string
        if (!is_null($expires) && !is_string($expires)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expires, true), gettype($expires)), __LINE__);
        }
        $this->expires = $expires;
        return $this;
    }
    /**
     * Get token value
     * @return string|null
     */
    public function getToken()
    {
        return $this->token;
    }
    /**
     * Set token value
     * @param string $token
     * @return \StructType\TokenInfo
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        $this->token = $token;
        return $this;
    }
}
