<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Tabella ServiceType
 * @subpackage Services
 */
class Tabella extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Tabella
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Tabella $parameters
     * @return \StructType\TabellaResponse|bool
     */
    public function Tabella(\StructType\Tabella $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Tabella($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TabellaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
