<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Authentication ServiceType
 * @subpackage Services
 */
class Authentication extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Authentication_Test
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Authentication_Test $parameters
     * @return \StructType\Authentication_TestResponse|bool
     */
    public function Authentication_Test(\StructType\Authentication_Test $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Authentication_Test($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Authentication_TestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
