<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fehler StructType
 * @subpackage Structs
 */
class Fehler extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * @var string
     */
    public $code;
    /**
     * The beschreibung
     * @var string
     */
    public $beschreibung;
    /**
     * The bezug
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $bezug;
    /**
     * Constructor method for fehler
     * @uses Fehler::setCode()
     * @uses Fehler::setBeschreibung()
     * @uses Fehler::setBezug()
     * @param string $code
     * @param string $beschreibung
     * @param string $bezug
     */
    public function __construct($code = null, $beschreibung = null, $bezug = null)
    {
        $this
            ->setCode($code)
            ->setBeschreibung($beschreibung)
            ->setBezug($bezug);
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \booking-assistent\StructType\Fehler
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($code) && mb_strlen($code) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get beschreibung value
     * @return string|null
     */
    public function getBeschreibung()
    {
        return $this->beschreibung;
    }
    /**
     * Set beschreibung value
     * @param string $beschreibung
     * @return \booking-assistent\StructType\Fehler
     */
    public function setBeschreibung($beschreibung = null)
    {
        // validation for constraint: string
        if (!is_null($beschreibung) && !is_string($beschreibung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($beschreibung, true), gettype($beschreibung)), __LINE__);
        }
        $this->beschreibung = $beschreibung;
        return $this;
    }
    /**
     * Get bezug value
     * @return string|null
     */
    public function getBezug()
    {
        return $this->bezug;
    }
    /**
     * Set bezug value
     * @param string $bezug
     * @return \booking-assistent\StructType\Fehler
     */
    public function setBezug($bezug = null)
    {
        // validation for constraint: string
        if (!is_null($bezug) && !is_string($bezug)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezug, true), gettype($bezug)), __LINE__);
        }
        $this->bezug = $bezug;
        return $this;
    }
}
