<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cObjekt StructType
 * @subpackage Structs
 */
class CObjekt extends AbstractStructBase
{
    /**
     * The bezeichnung
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 255
     * - maxOccurs: 1
     * - minLength: 3
     * - minOccurs: 1
     * @var string
     */
    public $bezeichnung;
    /**
     * The kurtaxzoneid
     * Meta information extracted from the WSDL
     * - base: xsd:long
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $kurtaxzoneid;
    /**
     * The kurtaxortid
     * Meta information extracted from the WSDL
     * - base: xsd:long
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $kurtaxortid;
    /**
     * The objektartid
     * Meta information extracted from the WSDL
     * - base: xsd:long
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $objektartid;
    /**
     * The adresse
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \booking-assistent\StructType\CAdresse[]
     */
    public $adresse;
    /**
     * The objektid
     * Meta information extracted from the WSDL
     * - base: xsd:long
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $objektid;
    /**
     * The betriebsschluessel
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 4
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * - pattern: [0-9]*
     * @var string
     */
    public $betriebsschluessel;
    /**
     * The sonderkennungid
     * Meta information extracted from the WSDL
     * - base: xsd:long
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $sonderkennungid;
    /**
     * The bettenanzahl
     * Meta information extracted from the WSDL
     * - base: xsd:int
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $bettenanzahl;
    /**
     * The rechnung_immer_eigentuemer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $rechnung_immer_eigentuemer;
    /**
     * Constructor method for cObjekt
     * @uses CObjekt::setBezeichnung()
     * @uses CObjekt::setKurtaxzoneid()
     * @uses CObjekt::setKurtaxortid()
     * @uses CObjekt::setObjektartid()
     * @uses CObjekt::setAdresse()
     * @uses CObjekt::setObjektid()
     * @uses CObjekt::setBetriebsschluessel()
     * @uses CObjekt::setSonderkennungid()
     * @uses CObjekt::setBettenanzahl()
     * @uses CObjekt::setRechnung_immer_eigentuemer()
     * @param string $bezeichnung
     * @param int $kurtaxzoneid
     * @param int $kurtaxortid
     * @param int $objektartid
     * @param \booking-assistent\StructType\CAdresse[] $adresse
     * @param int $objektid
     * @param string $betriebsschluessel
     * @param int $sonderkennungid
     * @param int $bettenanzahl
     * @param bool $rechnung_immer_eigentuemer
     */
    public function __construct($bezeichnung = null, $kurtaxzoneid = null, $kurtaxortid = null, $objektartid = null, array $adresse = array(), $objektid = null, $betriebsschluessel = null, $sonderkennungid = null, $bettenanzahl = null, $rechnung_immer_eigentuemer = null)
    {
        $this
            ->setBezeichnung($bezeichnung)
            ->setKurtaxzoneid($kurtaxzoneid)
            ->setKurtaxortid($kurtaxortid)
            ->setObjektartid($objektartid)
            ->setAdresse($adresse)
            ->setObjektid($objektid)
            ->setBetriebsschluessel($betriebsschluessel)
            ->setSonderkennungid($sonderkennungid)
            ->setBettenanzahl($bettenanzahl)
            ->setRechnung_immer_eigentuemer($rechnung_immer_eigentuemer);
    }
    /**
     * Get bezeichnung value
     * @return string
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * Set bezeichnung value
     * @param string $bezeichnung
     * @return \booking-assistent\StructType\CObjekt
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        // validation for constraint: maxLength(255)
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) > 255) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 255', mb_strlen($bezeichnung)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($bezeichnung) && mb_strlen($bezeichnung) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($bezeichnung)), __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get kurtaxzoneid value
     * @return int
     */
    public function getKurtaxzoneid()
    {
        return $this->kurtaxzoneid;
    }
    /**
     * Set kurtaxzoneid value
     * @param int $kurtaxzoneid
     * @return \booking-assistent\StructType\CObjekt
     */
    public function setKurtaxzoneid($kurtaxzoneid = null)
    {
        // validation for constraint: int
        if (!is_null($kurtaxzoneid) && !(is_int($kurtaxzoneid) || ctype_digit($kurtaxzoneid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kurtaxzoneid, true), gettype($kurtaxzoneid)), __LINE__);
        }
        $this->kurtaxzoneid = $kurtaxzoneid;
        return $this;
    }
    /**
     * Get kurtaxortid value
     * @return int
     */
    public function getKurtaxortid()
    {
        return $this->kurtaxortid;
    }
    /**
     * Set kurtaxortid value
     * @param int $kurtaxortid
     * @return \booking-assistent\StructType\CObjekt
     */
    public function setKurtaxortid($kurtaxortid = null)
    {
        // validation for constraint: int
        if (!is_null($kurtaxortid) && !(is_int($kurtaxortid) || ctype_digit($kurtaxortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kurtaxortid, true), gettype($kurtaxortid)), __LINE__);
        }
        $this->kurtaxortid = $kurtaxortid;
        return $this;
    }
    /**
     * Get objektartid value
     * @return int
     */
    public function getObjektartid()
    {
        return $this->objektartid;
    }
    /**
     * Set objektartid value
     * @param int $objektartid
     * @return \booking-assistent\StructType\CObjekt
     */
    public function setObjektartid($objektartid = null)
    {
        // validation for constraint: int
        if (!is_null($objektartid) && !(is_int($objektartid) || ctype_digit($objektartid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objektartid, true), gettype($objektartid)), __LINE__);
        }
        $this->objektartid = $objektartid;
        return $this;
    }
    /**
     * Get adresse value
     * @return \booking-assistent\StructType\CAdresse[]
     */
    public function getAdresse()
    {
        return $this->adresse;
    }
    /**
     * This method is responsible for validating the values passed to the setAdresse method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdresse method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdresseForArrayConstraintsFromSetAdresse(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cObjektAdresseItem) {
            // validation for constraint: itemType
            if (!$cObjektAdresseItem instanceof \booking-assistent\StructType\CAdresse) {
                $invalidValues[] = is_object($cObjektAdresseItem) ? get_class($cObjektAdresseItem) : sprintf('%s(%s)', gettype($cObjektAdresseItem), var_export($cObjektAdresseItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The adresse property can only contain items of type \booking-assistent\StructType\CAdresse, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set adresse value
     * @throws \InvalidArgumentException
     * @param \booking-assistent\StructType\CAdresse[] $adresse
     * @return \booking-assistent\StructType\CObjekt
     */
    public function setAdresse(array $adresse = array())
    {
        // validation for constraint: array
        if ('' !== ($adresseArrayErrorMessage = self::validateAdresseForArrayConstraintsFromSetAdresse($adresse))) {
            throw new \InvalidArgumentException($adresseArrayErrorMessage, __LINE__);
        }
        $this->adresse = $adresse;
        return $this;
    }
    /**
     * Add item to adresse value
     * @throws \InvalidArgumentException
     * @param \booking-assistent\StructType\CAdresse $item
     * @return \booking-assistent\StructType\CObjekt
     */
    public function addToAdresse(\booking-assistent\StructType\CAdresse $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \booking-assistent\StructType\CAdresse) {
            throw new \InvalidArgumentException(sprintf('The adresse property can only contain items of type \booking-assistent\StructType\CAdresse, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->adresse[] = $item;
        return $this;
    }
    /**
     * Get objektid value
     * @return int|null
     */
    public function getObjektid()
    {
        return $this->objektid;
    }
    /**
     * Set objektid value
     * @param int $objektid
     * @return \booking-assistent\StructType\CObjekt
     */
    public function setObjektid($objektid = null)
    {
        // validation for constraint: int
        if (!is_null($objektid) && !(is_int($objektid) || ctype_digit($objektid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objektid, true), gettype($objektid)), __LINE__);
        }
        $this->objektid = $objektid;
        return $this;
    }
    /**
     * Get betriebsschluessel value
     * @return string|null
     */
    public function getBetriebsschluessel()
    {
        return $this->betriebsschluessel;
    }
    /**
     * Set betriebsschluessel value
     * @param string $betriebsschluessel
     * @return \booking-assistent\StructType\CObjekt
     */
    public function setBetriebsschluessel($betriebsschluessel = null)
    {
        // validation for constraint: string
        if (!is_null($betriebsschluessel) && !is_string($betriebsschluessel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($betriebsschluessel, true), gettype($betriebsschluessel)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($betriebsschluessel) && mb_strlen($betriebsschluessel) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($betriebsschluessel)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($betriebsschluessel) && mb_strlen($betriebsschluessel) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($betriebsschluessel)), __LINE__);
        }
        // validation for constraint: pattern([0-9]*)
        if (!is_null($betriebsschluessel) && !preg_match('/[0-9]*/', $betriebsschluessel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]*', var_export($betriebsschluessel, true)), __LINE__);
        }
        $this->betriebsschluessel = $betriebsschluessel;
        return $this;
    }
    /**
     * Get sonderkennungid value
     * @return int|null
     */
    public function getSonderkennungid()
    {
        return $this->sonderkennungid;
    }
    /**
     * Set sonderkennungid value
     * @param int $sonderkennungid
     * @return \booking-assistent\StructType\CObjekt
     */
    public function setSonderkennungid($sonderkennungid = null)
    {
        // validation for constraint: int
        if (!is_null($sonderkennungid) && !(is_int($sonderkennungid) || ctype_digit($sonderkennungid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sonderkennungid, true), gettype($sonderkennungid)), __LINE__);
        }
        $this->sonderkennungid = $sonderkennungid;
        return $this;
    }
    /**
     * Get bettenanzahl value
     * @return int|null
     */
    public function getBettenanzahl()
    {
        return $this->bettenanzahl;
    }
    /**
     * Set bettenanzahl value
     * @param int $bettenanzahl
     * @return \booking-assistent\StructType\CObjekt
     */
    public function setBettenanzahl($bettenanzahl = null)
    {
        // validation for constraint: int
        if (!is_null($bettenanzahl) && !(is_int($bettenanzahl) || ctype_digit($bettenanzahl))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bettenanzahl, true), gettype($bettenanzahl)), __LINE__);
        }
        $this->bettenanzahl = $bettenanzahl;
        return $this;
    }
    /**
     * Get rechnung_immer_eigentuemer value
     * @return bool|null
     */
    public function getRechnung_immer_eigentuemer()
    {
        return $this->rechnung_immer_eigentuemer;
    }
    /**
     * Set rechnung_immer_eigentuemer value
     * @param bool $rechnung_immer_eigentuemer
     * @return \booking-assistent\StructType\CObjekt
     */
    public function setRechnung_immer_eigentuemer($rechnung_immer_eigentuemer = null)
    {
        // validation for constraint: boolean
        if (!is_null($rechnung_immer_eigentuemer) && !is_bool($rechnung_immer_eigentuemer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($rechnung_immer_eigentuemer, true), gettype($rechnung_immer_eigentuemer)), __LINE__);
        }
        $this->rechnung_immer_eigentuemer = $rechnung_immer_eigentuemer;
        return $this;
    }
}
