<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cMeldeschein StructType
 * @subpackage Structs
 */
class CMeldeschein extends AbstractStructBase
{
    /**
     * The firmaid
     * Meta information extracted from the WSDL
     * - base: xsd:long
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $firmaid;
    /**
     * The objektid
     * Meta information extracted from the WSDL
     * - base: xsd:long
     * - minOccurs: 1
     * - nillable: false
     * @var int
     */
    public $objektid;
    /**
     * The hauptperson
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \booking-assistent\StructType\CPerson
     */
    public $hauptperson;
    /**
     * The ort_id
     * Meta information extracted from the WSDL
     * - base: xsd:integer
     * @var int
     */
    public $ort_id;
    /**
     * The buchungsnummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $buchungsnummer;
    /**
     * The meldescheinnummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $meldescheinnummer;
    /**
     * The weitere_angaben
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $weitere_angaben;
    /**
     * The kfzkennzeichen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kfzkennzeichen;
    /**
     * The betrag
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - minOccurs: 0
     * @var float
     */
    public $betrag;
    /**
     * The abrechnungstatusid
     * Meta information extracted from the WSDL
     * - base: xsd:long
     * - minOccurs: 0
     * @var int
     */
    public $abrechnungstatusid;
    /**
     * The zusatzfelder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \booking-assistent\StructType\CMeldescheinZusatzfelder
     */
    public $zusatzfelder;
    /**
     * The begleitperson
     * Meta information extracted from the WSDL
     * - choice: begleitperson | begleitgruppe
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \booking-assistent\StructType\CPerson[]
     */
    public $begleitperson;
    /**
     * The begleitgruppe
     * Meta information extracted from the WSDL
     * - choice: begleitperson | begleitgruppe
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \booking-assistent\StructType\CBegleitgruppe[]
     */
    public $begleitgruppe;
    /**
     * The export_id
     * Meta information extracted from the WSDL
     * - base: xsd:integer
     * - minOccurs: 0
     * @var int
     */
    public $export_id;
    /**
     * Constructor method for cMeldeschein
     * @uses CMeldeschein::setFirmaid()
     * @uses CMeldeschein::setObjektid()
     * @uses CMeldeschein::setHauptperson()
     * @uses CMeldeschein::setOrt_id()
     * @uses CMeldeschein::setBuchungsnummer()
     * @uses CMeldeschein::setMeldescheinnummer()
     * @uses CMeldeschein::setWeitere_angaben()
     * @uses CMeldeschein::setKfzkennzeichen()
     * @uses CMeldeschein::setBetrag()
     * @uses CMeldeschein::setAbrechnungstatusid()
     * @uses CMeldeschein::setZusatzfelder()
     * @uses CMeldeschein::setBegleitperson()
     * @uses CMeldeschein::setBegleitgruppe()
     * @uses CMeldeschein::setExport_id()
     * @param int $firmaid
     * @param int $objektid
     * @param \booking-assistent\StructType\CPerson $hauptperson
     * @param int $ort_id
     * @param string $buchungsnummer
     * @param string $meldescheinnummer
     * @param string $weitere_angaben
     * @param string $kfzkennzeichen
     * @param float $betrag
     * @param int $abrechnungstatusid
     * @param \booking-assistent\StructType\CMeldescheinZusatzfelder $zusatzfelder
     * @param \booking-assistent\StructType\CPerson[] $begleitperson
     * @param \booking-assistent\StructType\CBegleitgruppe[] $begleitgruppe
     * @param int $export_id
     */
    public function __construct($firmaid = null, $objektid = null, \booking-assistent\StructType\CPerson $hauptperson = null, $ort_id = null, $buchungsnummer = null, $meldescheinnummer = null, $weitere_angaben = null, $kfzkennzeichen = null, $betrag = null, $abrechnungstatusid = null, \booking-assistent\StructType\CMeldescheinZusatzfelder $zusatzfelder = null, array $begleitperson = array(), array $begleitgruppe = array(), $export_id = null)
    {
        $this
            ->setFirmaid($firmaid)
            ->setObjektid($objektid)
            ->setHauptperson($hauptperson)
            ->setOrt_id($ort_id)
            ->setBuchungsnummer($buchungsnummer)
            ->setMeldescheinnummer($meldescheinnummer)
            ->setWeitere_angaben($weitere_angaben)
            ->setKfzkennzeichen($kfzkennzeichen)
            ->setBetrag($betrag)
            ->setAbrechnungstatusid($abrechnungstatusid)
            ->setZusatzfelder($zusatzfelder)
            ->setBegleitperson($begleitperson)
            ->setBegleitgruppe($begleitgruppe)
            ->setExport_id($export_id);
    }
    /**
     * Get firmaid value
     * @return int
     */
    public function getFirmaid()
    {
        return $this->firmaid;
    }
    /**
     * Set firmaid value
     * @param int $firmaid
     * @return \booking-assistent\StructType\CMeldeschein
     */
    public function setFirmaid($firmaid = null)
    {
        // validation for constraint: int
        if (!is_null($firmaid) && !(is_int($firmaid) || ctype_digit($firmaid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($firmaid, true), gettype($firmaid)), __LINE__);
        }
        $this->firmaid = $firmaid;
        return $this;
    }
    /**
     * Get objektid value
     * @return int
     */
    public function getObjektid()
    {
        return $this->objektid;
    }
    /**
     * Set objektid value
     * @param int $objektid
     * @return \booking-assistent\StructType\CMeldeschein
     */
    public function setObjektid($objektid = null)
    {
        // validation for constraint: int
        if (!is_null($objektid) && !(is_int($objektid) || ctype_digit($objektid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objektid, true), gettype($objektid)), __LINE__);
        }
        $this->objektid = $objektid;
        return $this;
    }
    /**
     * Get hauptperson value
     * @return \booking-assistent\StructType\CPerson
     */
    public function getHauptperson()
    {
        return $this->hauptperson;
    }
    /**
     * Set hauptperson value
     * @param \booking-assistent\StructType\CPerson $hauptperson
     * @return \booking-assistent\StructType\CMeldeschein
     */
    public function setHauptperson(\booking-assistent\StructType\CPerson $hauptperson = null)
    {
        $this->hauptperson = $hauptperson;
        return $this;
    }
    /**
     * Get ort_id value
     * @return int|null
     */
    public function getOrt_id()
    {
        return $this->{'ort-id'};
    }
    /**
     * Set ort_id value
     * @param int $ort_id
     * @return \booking-assistent\StructType\CMeldeschein
     */
    public function setOrt_id($ort_id = null)
    {
        // validation for constraint: int
        if (!is_null($ort_id) && !(is_int($ort_id) || ctype_digit($ort_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ort_id, true), gettype($ort_id)), __LINE__);
        }
        $this->ort_id = $this->{'ort-id'} = $ort_id;
        return $this;
    }
    /**
     * Get buchungsnummer value
     * @return string|null
     */
    public function getBuchungsnummer()
    {
        return $this->buchungsnummer;
    }
    /**
     * Set buchungsnummer value
     * @param string $buchungsnummer
     * @return \booking-assistent\StructType\CMeldeschein
     */
    public function setBuchungsnummer($buchungsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($buchungsnummer) && !is_string($buchungsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buchungsnummer, true), gettype($buchungsnummer)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($buchungsnummer) && mb_strlen($buchungsnummer) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($buchungsnummer)), __LINE__);
        }
        $this->buchungsnummer = $buchungsnummer;
        return $this;
    }
    /**
     * Get meldescheinnummer value
     * @return string|null
     */
    public function getMeldescheinnummer()
    {
        return $this->meldescheinnummer;
    }
    /**
     * Set meldescheinnummer value
     * @param string $meldescheinnummer
     * @return \booking-assistent\StructType\CMeldeschein
     */
    public function setMeldescheinnummer($meldescheinnummer = null)
    {
        // validation for constraint: string
        if (!is_null($meldescheinnummer) && !is_string($meldescheinnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meldescheinnummer, true), gettype($meldescheinnummer)), __LINE__);
        }
        $this->meldescheinnummer = $meldescheinnummer;
        return $this;
    }
    /**
     * Get weitere_angaben value
     * @return string|null
     */
    public function getWeitere_angaben()
    {
        return $this->weitere_angaben;
    }
    /**
     * Set weitere_angaben value
     * @param string $weitere_angaben
     * @return \booking-assistent\StructType\CMeldeschein
     */
    public function setWeitere_angaben($weitere_angaben = null)
    {
        // validation for constraint: string
        if (!is_null($weitere_angaben) && !is_string($weitere_angaben)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($weitere_angaben, true), gettype($weitere_angaben)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($weitere_angaben) && mb_strlen($weitere_angaben) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($weitere_angaben)), __LINE__);
        }
        $this->weitere_angaben = $weitere_angaben;
        return $this;
    }
    /**
     * Get kfzkennzeichen value
     * @return string|null
     */
    public function getKfzkennzeichen()
    {
        return $this->kfzkennzeichen;
    }
    /**
     * Set kfzkennzeichen value
     * @param string $kfzkennzeichen
     * @return \booking-assistent\StructType\CMeldeschein
     */
    public function setKfzkennzeichen($kfzkennzeichen = null)
    {
        // validation for constraint: string
        if (!is_null($kfzkennzeichen) && !is_string($kfzkennzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kfzkennzeichen, true), gettype($kfzkennzeichen)), __LINE__);
        }
        $this->kfzkennzeichen = $kfzkennzeichen;
        return $this;
    }
    /**
     * Get betrag value
     * @return float|null
     */
    public function getBetrag()
    {
        return $this->betrag;
    }
    /**
     * Set betrag value
     * @param float $betrag
     * @return \booking-assistent\StructType\CMeldeschein
     */
    public function setBetrag($betrag = null)
    {
        // validation for constraint: float
        if (!is_null($betrag) && !(is_float($betrag) || is_numeric($betrag))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($betrag, true), gettype($betrag)), __LINE__);
        }
        $this->betrag = $betrag;
        return $this;
    }
    /**
     * Get abrechnungstatusid value
     * @return int|null
     */
    public function getAbrechnungstatusid()
    {
        return $this->abrechnungstatusid;
    }
    /**
     * Set abrechnungstatusid value
     * @param int $abrechnungstatusid
     * @return \booking-assistent\StructType\CMeldeschein
     */
    public function setAbrechnungstatusid($abrechnungstatusid = null)
    {
        // validation for constraint: int
        if (!is_null($abrechnungstatusid) && !(is_int($abrechnungstatusid) || ctype_digit($abrechnungstatusid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abrechnungstatusid, true), gettype($abrechnungstatusid)), __LINE__);
        }
        $this->abrechnungstatusid = $abrechnungstatusid;
        return $this;
    }
    /**
     * Get zusatzfelder value
     * @return \booking-assistent\StructType\CMeldescheinZusatzfelder|null
     */
    public function getZusatzfelder()
    {
        return $this->zusatzfelder;
    }
    /**
     * Set zusatzfelder value
     * @param \booking-assistent\StructType\CMeldescheinZusatzfelder $zusatzfelder
     * @return \booking-assistent\StructType\CMeldeschein
     */
    public function setZusatzfelder(\booking-assistent\StructType\CMeldescheinZusatzfelder $zusatzfelder = null)
    {
        $this->zusatzfelder = $zusatzfelder;
        return $this;
    }
    /**
     * Get begleitperson value
     * @return \booking-assistent\StructType\CPerson[]|null
     */
    public function getBegleitperson()
    {
        return isset($this->begleitperson) ? $this->begleitperson : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBegleitperson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBegleitperson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBegleitpersonForArrayConstraintsFromSetBegleitperson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cMeldescheinBegleitpersonItem) {
            // validation for constraint: itemType
            if (!$cMeldescheinBegleitpersonItem instanceof \booking-assistent\StructType\CPerson) {
                $invalidValues[] = is_object($cMeldescheinBegleitpersonItem) ? get_class($cMeldescheinBegleitpersonItem) : sprintf('%s(%s)', gettype($cMeldescheinBegleitpersonItem), var_export($cMeldescheinBegleitpersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The begleitperson property can only contain items of type \booking-assistent\StructType\CPerson, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setBegleitperson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBegleitperson method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBegleitpersonForChoiceConstraintsFromSetBegleitperson($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'begleitgruppe',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property begleitperson can\'t be set as the property %s is already set. Only one property must be set among these properties: begleitperson, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set begleitperson value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \booking-assistent\StructType\CPerson[] $begleitperson
     * @return \booking-assistent\StructType\CMeldeschein
     */
    public function setBegleitperson(array $begleitperson = array())
    {
        // validation for constraint: array
        if ('' !== ($begleitpersonArrayErrorMessage = self::validateBegleitpersonForArrayConstraintsFromSetBegleitperson($begleitperson))) {
            throw new \InvalidArgumentException($begleitpersonArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(begleitperson, begleitgruppe)
        if ('' !== ($begleitpersonChoiceErrorMessage = self::validateBegleitpersonForChoiceConstraintsFromSetBegleitperson($begleitperson))) {
            throw new \InvalidArgumentException($begleitpersonChoiceErrorMessage, __LINE__);
        }
        if (is_null($begleitperson) || (is_array($begleitperson) && empty($begleitperson))) {
            unset($this->begleitperson);
        } else {
            $this->begleitperson = $begleitperson;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToBegleitperson method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToBegleitperson method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToBegleitperson($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'begleitgruppe',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property begleitperson can\'t be set as the property %s is already set. Only one property must be set among these properties: begleitperson, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to begleitperson value
     * @throws \InvalidArgumentException
     * @param \booking-assistent\StructType\CPerson $item
     * @return \booking-assistent\StructType\CMeldeschein
     */
    public function addToBegleitperson(\booking-assistent\StructType\CPerson $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \booking-assistent\StructType\CPerson) {
            throw new \InvalidArgumentException(sprintf('The begleitperson property can only contain items of type \booking-assistent\StructType\CPerson, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(begleitperson, begleitgruppe)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToBegleitperson($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->begleitperson[] = $item;
        return $this;
    }
    /**
     * Get begleitgruppe value
     * @return \booking-assistent\StructType\CBegleitgruppe[]|null
     */
    public function getBegleitgruppe()
    {
        return isset($this->begleitgruppe) ? $this->begleitgruppe : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBegleitgruppe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBegleitgruppe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBegleitgruppeForArrayConstraintsFromSetBegleitgruppe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cMeldescheinBegleitgruppeItem) {
            // validation for constraint: itemType
            if (!$cMeldescheinBegleitgruppeItem instanceof \booking-assistent\StructType\CBegleitgruppe) {
                $invalidValues[] = is_object($cMeldescheinBegleitgruppeItem) ? get_class($cMeldescheinBegleitgruppeItem) : sprintf('%s(%s)', gettype($cMeldescheinBegleitgruppeItem), var_export($cMeldescheinBegleitgruppeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The begleitgruppe property can only contain items of type \booking-assistent\StructType\CBegleitgruppe, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setBegleitgruppe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBegleitgruppe method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBegleitgruppeForChoiceConstraintsFromSetBegleitgruppe($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'begleitperson',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property begleitgruppe can\'t be set as the property %s is already set. Only one property must be set among these properties: begleitgruppe, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set begleitgruppe value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @throws \InvalidArgumentException
     * @param \booking-assistent\StructType\CBegleitgruppe[] $begleitgruppe
     * @return \booking-assistent\StructType\CMeldeschein
     */
    public function setBegleitgruppe(array $begleitgruppe = array())
    {
        // validation for constraint: array
        if ('' !== ($begleitgruppeArrayErrorMessage = self::validateBegleitgruppeForArrayConstraintsFromSetBegleitgruppe($begleitgruppe))) {
            throw new \InvalidArgumentException($begleitgruppeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: choice(begleitperson, begleitgruppe)
        if ('' !== ($begleitgruppeChoiceErrorMessage = self::validateBegleitgruppeForChoiceConstraintsFromSetBegleitgruppe($begleitgruppe))) {
            throw new \InvalidArgumentException($begleitgruppeChoiceErrorMessage, __LINE__);
        }
        if (is_null($begleitgruppe) || (is_array($begleitgruppe) && empty($begleitgruppe))) {
            unset($this->begleitgruppe);
        } else {
            $this->begleitgruppe = $begleitgruppe;
        }
        return $this;
    }
    /**
     * This method is responsible for validating the value passed to the addToBegleitgruppe method
     * This method is willingly generated in order to preserve the one-line inline validation within the addToBegleitgruppe method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateItemForChoiceConstraintsFromAddToBegleitgruppe($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'begleitperson',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property begleitgruppe can\'t be set as the property %s is already set. Only one property must be set among these properties: begleitgruppe, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Add item to begleitgruppe value
     * @throws \InvalidArgumentException
     * @param \booking-assistent\StructType\CBegleitgruppe $item
     * @return \booking-assistent\StructType\CMeldeschein
     */
    public function addToBegleitgruppe(\booking-assistent\StructType\CBegleitgruppe $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \booking-assistent\StructType\CBegleitgruppe) {
            throw new \InvalidArgumentException(sprintf('The begleitgruppe property can only contain items of type \booking-assistent\StructType\CBegleitgruppe, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: choice(begleitperson, begleitgruppe)
        if ('' !== ($itemChoiceErrorMessage = self::validateItemForChoiceConstraintsFromAddToBegleitgruppe($item))) {
            throw new \InvalidArgumentException($itemChoiceErrorMessage, __LINE__);
        }
        $this->begleitgruppe[] = $item;
        return $this;
    }
    /**
     * Get export_id value
     * @return int|null
     */
    public function getExport_id()
    {
        return $this->{'export-id'};
    }
    /**
     * Set export_id value
     * @param int $export_id
     * @return \booking-assistent\StructType\CMeldeschein
     */
    public function setExport_id($export_id = null)
    {
        // validation for constraint: int
        if (!is_null($export_id) && !(is_int($export_id) || ctype_digit($export_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($export_id, true), gettype($export_id)), __LINE__);
        }
        $this->export_id = $this->{'export-id'} = $export_id;
        return $this;
    }
}
