<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cKurtaxort StructType
 * @subpackage Structs
 */
class CKurtaxort extends AbstractStructBase
{
    /**
     * The kurtaxortid
     * Meta information extracted from the WSDL
     * - base: xsd:long
     * @var int
     */
    public $kurtaxortid;
    /**
     * The bezeichnung
     * @var string
     */
    public $bezeichnung;
    /**
     * Constructor method for cKurtaxort
     * @uses CKurtaxort::setKurtaxortid()
     * @uses CKurtaxort::setBezeichnung()
     * @param int $kurtaxortid
     * @param string $bezeichnung
     */
    public function __construct($kurtaxortid = null, $bezeichnung = null)
    {
        $this
            ->setKurtaxortid($kurtaxortid)
            ->setBezeichnung($bezeichnung);
    }
    /**
     * Get kurtaxortid value
     * @return int|null
     */
    public function getKurtaxortid()
    {
        return $this->kurtaxortid;
    }
    /**
     * Set kurtaxortid value
     * @param int $kurtaxortid
     * @return \booking-assistent\StructType\CKurtaxort
     */
    public function setKurtaxortid($kurtaxortid = null)
    {
        // validation for constraint: int
        if (!is_null($kurtaxortid) && !(is_int($kurtaxortid) || ctype_digit($kurtaxortid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kurtaxortid, true), gettype($kurtaxortid)), __LINE__);
        }
        $this->kurtaxortid = $kurtaxortid;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return string|null
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * Set bezeichnung value
     * @param string $bezeichnung
     * @return \booking-assistent\StructType\CKurtaxort
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
}
