<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cKommunikation StructType
 * @subpackage Structs
 */
class CKommunikation extends AbstractStructBase
{
    /**
     * The anschlusstypid
     * Meta information extracted from the WSDL
     * - base: xsd:long
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $anschlusstypid;
    /**
     * The anschlusskennung
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * - minOccurs: 0
     * @var string
     */
    public $anschlusskennung;
    /**
     * Constructor method for cKommunikation
     * @uses CKommunikation::setAnschlusstypid()
     * @uses CKommunikation::setAnschlusskennung()
     * @param int $anschlusstypid
     * @param string $anschlusskennung
     */
    public function __construct($anschlusstypid = null, $anschlusskennung = null)
    {
        $this
            ->setAnschlusstypid($anschlusstypid)
            ->setAnschlusskennung($anschlusskennung);
    }
    /**
     * Get anschlusstypid value
     * @return int
     */
    public function getAnschlusstypid()
    {
        return $this->anschlusstypid;
    }
    /**
     * Set anschlusstypid value
     * @param int $anschlusstypid
     * @return \booking-assistent\StructType\CKommunikation
     */
    public function setAnschlusstypid($anschlusstypid = null)
    {
        // validation for constraint: int
        if (!is_null($anschlusstypid) && !(is_int($anschlusstypid) || ctype_digit($anschlusstypid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anschlusstypid, true), gettype($anschlusstypid)), __LINE__);
        }
        $this->anschlusstypid = $anschlusstypid;
        return $this;
    }
    /**
     * Get anschlusskennung value
     * @return string|null
     */
    public function getAnschlusskennung()
    {
        return $this->anschlusskennung;
    }
    /**
     * Set anschlusskennung value
     * @param string $anschlusskennung
     * @return \booking-assistent\StructType\CKommunikation
     */
    public function setAnschlusskennung($anschlusskennung = null)
    {
        // validation for constraint: string
        if (!is_null($anschlusskennung) && !is_string($anschlusskennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anschlusskennung, true), gettype($anschlusskennung)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($anschlusskennung) && mb_strlen($anschlusskennung) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($anschlusskennung)), __LINE__);
        }
        $this->anschlusskennung = $anschlusskennung;
        return $this;
    }
}
