<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cIdentifikation StructType
 * @subpackage Structs
 */
class CIdentifikation extends AbstractStructBase
{
    /**
     * The verarbeitung
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 1
     * @var string
     */
    public $verarbeitung;
    /**
     * The erzeugung
     * @var string
     */
    public $erzeugung;
    /**
     * The schnittstelle
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * @var string
     */
    public $schnittstelle;
    /**
     * The kurverwaltung
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * @var string
     */
    public $kurverwaltung;
    /**
     * The benutzerid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $benutzerid;
    /**
     * The sessionid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $sessionid;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $version;
    /**
     * Constructor method for cIdentifikation
     * @uses CIdentifikation::setVerarbeitung()
     * @uses CIdentifikation::setErzeugung()
     * @uses CIdentifikation::setSchnittstelle()
     * @uses CIdentifikation::setKurverwaltung()
     * @uses CIdentifikation::setBenutzerid()
     * @uses CIdentifikation::setSessionid()
     * @uses CIdentifikation::setVersion()
     * @param string $verarbeitung
     * @param string $erzeugung
     * @param string $schnittstelle
     * @param string $kurverwaltung
     * @param int $benutzerid
     * @param string $sessionid
     * @param string $version
     */
    public function __construct($verarbeitung = null, $erzeugung = null, $schnittstelle = null, $kurverwaltung = null, $benutzerid = null, $sessionid = null, $version = null)
    {
        $this
            ->setVerarbeitung($verarbeitung)
            ->setErzeugung($erzeugung)
            ->setSchnittstelle($schnittstelle)
            ->setKurverwaltung($kurverwaltung)
            ->setBenutzerid($benutzerid)
            ->setSessionid($sessionid)
            ->setVersion($version);
    }
    /**
     * Get verarbeitung value
     * @return string
     */
    public function getVerarbeitung()
    {
        return $this->verarbeitung;
    }
    /**
     * Set verarbeitung value
     * @param string $verarbeitung
     * @return \booking-assistent\StructType\CIdentifikation
     */
    public function setVerarbeitung($verarbeitung = null)
    {
        // validation for constraint: string
        if (!is_null($verarbeitung) && !is_string($verarbeitung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verarbeitung, true), gettype($verarbeitung)), __LINE__);
        }
        $this->verarbeitung = $verarbeitung;
        return $this;
    }
    /**
     * Get erzeugung value
     * @return string|null
     */
    public function getErzeugung()
    {
        return $this->erzeugung;
    }
    /**
     * Set erzeugung value
     * @param string $erzeugung
     * @return \booking-assistent\StructType\CIdentifikation
     */
    public function setErzeugung($erzeugung = null)
    {
        // validation for constraint: string
        if (!is_null($erzeugung) && !is_string($erzeugung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erzeugung, true), gettype($erzeugung)), __LINE__);
        }
        $this->erzeugung = $erzeugung;
        return $this;
    }
    /**
     * Get schnittstelle value
     * @return string|null
     */
    public function getSchnittstelle()
    {
        return $this->schnittstelle;
    }
    /**
     * Set schnittstelle value
     * @param string $schnittstelle
     * @return \booking-assistent\StructType\CIdentifikation
     */
    public function setSchnittstelle($schnittstelle = null)
    {
        // validation for constraint: string
        if (!is_null($schnittstelle) && !is_string($schnittstelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schnittstelle, true), gettype($schnittstelle)), __LINE__);
        }
        $this->schnittstelle = $schnittstelle;
        return $this;
    }
    /**
     * Get kurverwaltung value
     * @return string|null
     */
    public function getKurverwaltung()
    {
        return $this->kurverwaltung;
    }
    /**
     * Set kurverwaltung value
     * @param string $kurverwaltung
     * @return \booking-assistent\StructType\CIdentifikation
     */
    public function setKurverwaltung($kurverwaltung = null)
    {
        // validation for constraint: string
        if (!is_null($kurverwaltung) && !is_string($kurverwaltung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kurverwaltung, true), gettype($kurverwaltung)), __LINE__);
        }
        $this->kurverwaltung = $kurverwaltung;
        return $this;
    }
    /**
     * Get benutzerid value
     * @return int|null
     */
    public function getBenutzerid()
    {
        return $this->benutzerid;
    }
    /**
     * Set benutzerid value
     * @param int $benutzerid
     * @return \booking-assistent\StructType\CIdentifikation
     */
    public function setBenutzerid($benutzerid = null)
    {
        // validation for constraint: int
        if (!is_null($benutzerid) && !(is_int($benutzerid) || ctype_digit($benutzerid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($benutzerid, true), gettype($benutzerid)), __LINE__);
        }
        $this->benutzerid = $benutzerid;
        return $this;
    }
    /**
     * Get sessionid value
     * @return string|null
     */
    public function getSessionid()
    {
        return $this->sessionid;
    }
    /**
     * Set sessionid value
     * @param string $sessionid
     * @return \booking-assistent\StructType\CIdentifikation
     */
    public function setSessionid($sessionid = null)
    {
        // validation for constraint: string
        if (!is_null($sessionid) && !is_string($sessionid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionid, true), gettype($sessionid)), __LINE__);
        }
        $this->sessionid = $sessionid;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \booking-assistent\StructType\CIdentifikation
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($version) && mb_strlen($version) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
