<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for anfragedaten StructType
 * @subpackage Structs
 */
class Anfragedaten extends AbstractStructBase
{
    /**
     * The meldescheinnummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: meldescheinnummer | buchungsnummer | objektid | buchungsnummer | meldescheinnummer | ort-id
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var string
     */
    public $meldescheinnummer;
    /**
     * The buchungsnummer
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: meldescheinnummer | buchungsnummer | objektid | buchungsnummer | meldescheinnummer | ort-id
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 50
     * @var string
     */
    public $buchungsnummer;
    /**
     * The objektid
     * Meta information extracted from the WSDL
     * - base: xsd:integer
     * - choice: meldescheinnummer | buchungsnummer | objektid
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * - nillable: false
     * @var int
     */
    public $objektid;
    /**
     * The ort_id
     * Meta information extracted from the WSDL
     * - base: xsd:integer
     * - choice: buchungsnummer | meldescheinnummer | ort-id
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var int
     */
    public $ort_id;
    /**
     * Constructor method for anfragedaten
     * @uses Anfragedaten::setMeldescheinnummer()
     * @uses Anfragedaten::setBuchungsnummer()
     * @uses Anfragedaten::setObjektid()
     * @uses Anfragedaten::setOrt_id()
     * @param string $meldescheinnummer
     * @param string $buchungsnummer
     * @param int $objektid
     * @param int $ort_id
     */
    public function __construct($meldescheinnummer = null, $buchungsnummer = null, $objektid = null, $ort_id = null)
    {
        $this
            ->setMeldescheinnummer($meldescheinnummer)
            ->setBuchungsnummer($buchungsnummer)
            ->setObjektid($objektid)
            ->setOrt_id($ort_id);
    }
    /**
     * Get meldescheinnummer value
     * @return string|null
     */
    public function getMeldescheinnummer()
    {
        return isset($this->meldescheinnummer) ? $this->meldescheinnummer : null;
    }
    /**
     * This method is responsible for validating the value passed to the setMeldescheinnummer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeldescheinnummer method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateMeldescheinnummerForChoiceConstraintsFromSetMeldescheinnummer($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'buchungsnummer',
            'objektid',
            'buchungsnummer',
            'ort_id',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property meldescheinnummer can\'t be set as the property %s is already set. Only one property must be set among these properties: meldescheinnummer, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set meldescheinnummer value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $meldescheinnummer
     * @return \booking-assistent\StructType\Anfragedaten
     */
    public function setMeldescheinnummer($meldescheinnummer = null)
    {
        // validation for constraint: string
        if (!is_null($meldescheinnummer) && !is_string($meldescheinnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meldescheinnummer, true), gettype($meldescheinnummer)), __LINE__);
        }
        // validation for constraint: choice(meldescheinnummer, buchungsnummer, objektid, buchungsnummer, meldescheinnummer, ort-id)
        if ('' !== ($meldescheinnummerChoiceErrorMessage = self::validateMeldescheinnummerForChoiceConstraintsFromSetMeldescheinnummer($meldescheinnummer))) {
            throw new \InvalidArgumentException($meldescheinnummerChoiceErrorMessage, __LINE__);
        }
        if (is_null($meldescheinnummer) || (is_array($meldescheinnummer) && empty($meldescheinnummer))) {
            unset($this->meldescheinnummer);
        } else {
            $this->meldescheinnummer = $meldescheinnummer;
        }
        return $this;
    }
    /**
     * Get buchungsnummer value
     * @return string|null
     */
    public function getBuchungsnummer()
    {
        return isset($this->buchungsnummer) ? $this->buchungsnummer : null;
    }
    /**
     * This method is responsible for validating the value passed to the setBuchungsnummer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBuchungsnummer method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateBuchungsnummerForChoiceConstraintsFromSetBuchungsnummer($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'meldescheinnummer',
            'objektid',
            'meldescheinnummer',
            'ort_id',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property buchungsnummer can\'t be set as the property %s is already set. Only one property must be set among these properties: buchungsnummer, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set buchungsnummer value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $buchungsnummer
     * @return \booking-assistent\StructType\Anfragedaten
     */
    public function setBuchungsnummer($buchungsnummer = null)
    {
        // validation for constraint: string
        if (!is_null($buchungsnummer) && !is_string($buchungsnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buchungsnummer, true), gettype($buchungsnummer)), __LINE__);
        }
        // validation for constraint: choice(meldescheinnummer, buchungsnummer, objektid, buchungsnummer, meldescheinnummer, ort-id)
        if ('' !== ($buchungsnummerChoiceErrorMessage = self::validateBuchungsnummerForChoiceConstraintsFromSetBuchungsnummer($buchungsnummer))) {
            throw new \InvalidArgumentException($buchungsnummerChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($buchungsnummer) && mb_strlen($buchungsnummer) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($buchungsnummer)), __LINE__);
        }
        if (is_null($buchungsnummer) || (is_array($buchungsnummer) && empty($buchungsnummer))) {
            unset($this->buchungsnummer);
        } else {
            $this->buchungsnummer = $buchungsnummer;
        }
        return $this;
    }
    /**
     * Get objektid value
     * @return int|null
     */
    public function getObjektid()
    {
        return isset($this->objektid) ? $this->objektid : null;
    }
    /**
     * This method is responsible for validating the value passed to the setObjektid method
     * This method is willingly generated in order to preserve the one-line inline validation within the setObjektid method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateObjektidForChoiceConstraintsFromSetObjektid($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'meldescheinnummer',
            'buchungsnummer',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property objektid can\'t be set as the property %s is already set. Only one property must be set among these properties: objektid, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set objektid value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $objektid
     * @return \booking-assistent\StructType\Anfragedaten
     */
    public function setObjektid($objektid = null)
    {
        // validation for constraint: int
        if (!is_null($objektid) && !(is_int($objektid) || ctype_digit($objektid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objektid, true), gettype($objektid)), __LINE__);
        }
        // validation for constraint: choice(meldescheinnummer, buchungsnummer, objektid)
        if ('' !== ($objektidChoiceErrorMessage = self::validateObjektidForChoiceConstraintsFromSetObjektid($objektid))) {
            throw new \InvalidArgumentException($objektidChoiceErrorMessage, __LINE__);
        }
        if (is_null($objektid) || (is_array($objektid) && empty($objektid))) {
            unset($this->objektid);
        } else {
            $this->objektid = $objektid;
        }
        return $this;
    }
    /**
     * Get ort_id value
     * @return int|null
     */
    public function getOrt_id()
    {
        return isset($this->{'ort-id'}) ? $this->{'ort-id'} : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOrt_id method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrt_id method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOrt_idForChoiceConstraintsFromSetOrt_id($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'buchungsnummer',
            'meldescheinnummer',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ort-id can\'t be set as the property %s is already set. Only one property must be set among these properties: ort-id, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ort_id value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param int $ort_id
     * @return \booking-assistent\StructType\Anfragedaten
     */
    public function setOrt_id($ort_id = null)
    {
        // validation for constraint: int
        if (!is_null($ort_id) && !(is_int($ort_id) || ctype_digit($ort_id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ort_id, true), gettype($ort_id)), __LINE__);
        }
        // validation for constraint: choice(buchungsnummer, meldescheinnummer, ort-id)
        if ('' !== ($ort_idChoiceErrorMessage = self::validateOrt_idForChoiceConstraintsFromSetOrt_id($ort_id))) {
            throw new \InvalidArgumentException($ort_idChoiceErrorMessage, __LINE__);
        }
        if (is_null($ort_id) || (is_array($ort_id) && empty($ort_id))) {
            unset($this->ort_id, $this->{'ort-id'});
        } else {
            $this->ort_id = $this->{'ort-id'} = $ort_id;
        }
        return $this;
    }
}
