<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://meldeschein.avs.de/meldeschein-ws-prod/wsdl/IJMeldescheinWebservices.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://meldeschein.avs.de/meldeschein-ws-prod/wsdl/IJMeldescheinWebservices.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \booking-assistent\ClassMap::get(),
);
/**
 * Samples for Drucke ServiceType
 */
$drucke = new \booking-assistent\ServiceType\Drucke($options);
/**
 * Sample call for druckeMeldescheine operation/method
 */
if ($drucke->druckeMeldescheine(new \booking-assistent\StructType\DruckeMeldescheineRequest()) !== false) {
    print_r($drucke->getResult());
} else {
    print_r($drucke->getLastError());
}
/**
 * Samples for Buche ServiceType
 */
$buche = new \booking-assistent\ServiceType\Buche($options);
/**
 * Sample call for bucheMeldeschein operation/method
 */
if ($buche->bucheMeldeschein(new \booking-assistent\StructType\Meldescheine()) !== false) {
    print_r($buche->getResult());
} else {
    print_r($buche->getLastError());
}
/**
 * Samples for Hole ServiceType
 */
$hole = new \booking-assistent\ServiceType\Hole($options);
/**
 * Sample call for holeMeldeschein operation/method
 */
if ($hole->holeMeldeschein(new \booking-assistent\StructType\HoleMeldeschein()) !== false) {
    print_r($hole->getResult());
} else {
    print_r($hole->getLastError());
}
/**
 * Sample call for holeMeldescheine operation/method
 */
if ($hole->holeMeldescheine(new \booking-assistent\StructType\HoleMeldescheineRequest()) !== false) {
    print_r($hole->getResult());
} else {
    print_r($hole->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \booking-assistent\ServiceType\Get($options);
/**
 * Sample call for getKonfigurationsListe operation/method
 */
if ($get->getKonfigurationsListe(new \booking-assistent\StructType\Configuration_lists()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
