<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for registerMeldescheineRequest StructType
 * @subpackage Structs
 */
class RegisterMeldescheineRequest extends AbstractStructBase
{
    /**
     * The export_id
     * Meta information extracted from the WSDL
     * - base: xsd:integer
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var int[]
     */
    public $export_id;
    /**
     * The identifikation
     * @var \booking-assistent\StructType\CIdentifikation
     */
    public $identifikation;
    /**
     * Constructor method for registerMeldescheineRequest
     * @uses RegisterMeldescheineRequest::setExport_id()
     * @uses RegisterMeldescheineRequest::setIdentifikation()
     * @param int[] $export_id
     * @param \booking-assistent\StructType\CIdentifikation $identifikation
     */
    public function __construct(array $export_id = array(), \booking-assistent\StructType\CIdentifikation $identifikation = null)
    {
        $this
            ->setExport_id($export_id)
            ->setIdentifikation($identifikation);
    }
    /**
     * Get export_id value
     * @return int[]
     */
    public function getExport_id()
    {
        return $this->{'export-id'};
    }
    /**
     * This method is responsible for validating the values passed to the setExport_id method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExport_id method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExport_idForArrayConstraintsFromSetExport_id(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $registerMeldescheineRequestExport_idItem) {
            // validation for constraint: itemType
            if (!(is_int($registerMeldescheineRequestExport_idItem) || ctype_digit($registerMeldescheineRequestExport_idItem))) {
                $invalidValues[] = is_object($registerMeldescheineRequestExport_idItem) ? get_class($registerMeldescheineRequestExport_idItem) : sprintf('%s(%s)', gettype($registerMeldescheineRequestExport_idItem), var_export($registerMeldescheineRequestExport_idItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The export_id property can only contain items of type integer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set export_id value
     * @throws \InvalidArgumentException
     * @param int[] $export_id
     * @return \booking-assistent\StructType\RegisterMeldescheineRequest
     */
    public function setExport_id(array $export_id = array())
    {
        // validation for constraint: array
        if ('' !== ($export_idArrayErrorMessage = self::validateExport_idForArrayConstraintsFromSetExport_id($export_id))) {
            throw new \InvalidArgumentException($export_idArrayErrorMessage, __LINE__);
        }
        $this->export_id = $this->{'export-id'} = $export_id;
        return $this;
    }
    /**
     * Add item to export_id value
     * @throws \InvalidArgumentException
     * @param int $item
     * @return \booking-assistent\StructType\RegisterMeldescheineRequest
     */
    public function addToExport_id($item)
    {
        // validation for constraint: itemType
        if (!(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('The export_id property can only contain items of type integer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->export_id[] = $this->{'export-id'}[] = $item;
        return $this;
    }
    /**
     * Get identifikation value
     * @return \booking-assistent\StructType\CIdentifikation|null
     */
    public function getIdentifikation()
    {
        return $this->identifikation;
    }
    /**
     * Set identifikation value
     * @param \booking-assistent\StructType\CIdentifikation $identifikation
     * @return \booking-assistent\StructType\RegisterMeldescheineRequest
     */
    public function setIdentifikation(\booking-assistent\StructType\CIdentifikation $identifikation = null)
    {
        $this->identifikation = $identifikation;
        return $this;
    }
}
