<?php

namespace booking-assistent\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for generic-response StructType
 * @subpackage Structs
 */
class Generic_response extends AbstractStructBase
{
    /**
     * The fehlermeldungen
     * Meta information extracted from the WSDL
     * - minOccurs: 1
     * @var \booking-assistent\StructType\CFehlermeldungen
     */
    public $fehlermeldungen;
    /**
     * The version
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $version;
    /**
     * Constructor method for generic-response
     * @uses Generic_response::setFehlermeldungen()
     * @uses Generic_response::setVersion()
     * @param \booking-assistent\StructType\CFehlermeldungen $fehlermeldungen
     * @param string $version
     */
    public function __construct(\booking-assistent\StructType\CFehlermeldungen $fehlermeldungen = null, $version = null)
    {
        $this
            ->setFehlermeldungen($fehlermeldungen)
            ->setVersion($version);
    }
    /**
     * Get fehlermeldungen value
     * @return \booking-assistent\StructType\CFehlermeldungen
     */
    public function getFehlermeldungen()
    {
        return $this->fehlermeldungen;
    }
    /**
     * Set fehlermeldungen value
     * @param \booking-assistent\StructType\CFehlermeldungen $fehlermeldungen
     * @return \booking-assistent\StructType\Generic_response
     */
    public function setFehlermeldungen(\booking-assistent\StructType\CFehlermeldungen $fehlermeldungen = null)
    {
        $this->fehlermeldungen = $fehlermeldungen;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \booking-assistent\StructType\Generic_response
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($version) && mb_strlen($version) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
}
